package gov.va.med.esr.common.model.ee;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.esr.common.model.lookup.MHDataSource;
import gov.va.med.esr.common.model.lookup.MsdsCountry;
import gov.va.med.esr.common.model.lookup.SpecialOperation;
import gov.va.med.esr.common.model.lookup.TerminationReason;
import gov.va.med.esr.common.model.lookup.Country;
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 
 * @author DNS   ruizc
 * @version 1.0
 *
 */
public class Deployment extends AbstractKeyedEntity {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 4832999014714554986L;

	// Special Operation Code
	private SpecialOperation specialOperation;
	
	// Country/Location code
	private MsdsCountry country;
	
	private TerminationReason terminationReason;
	
	// Deployment begin date
	private Date deploymentBeginDate;
	
	// Deployment end date
	private Date deploymentEndDate;

	private MHDataSource dataSource;	
	
	private Activation activation;

	public MsdsCountry getCountry() {
		return country;
	}

	public void setCountry(MsdsCountry country) {
		this.country = country;
	}

	public Date getDeploymentBeginDate() {
		return deploymentBeginDate;
	}

	public void setDeploymentBeginDate(Date deploymentBeginDate) {
		this.deploymentBeginDate = deploymentBeginDate;
	}

	public Date getDeploymentEndDate() {
		return deploymentEndDate;
	}

	public void setDeploymentEndDate(Date deploymentEndDate) {
		this.deploymentEndDate = deploymentEndDate;
	}

	public SpecialOperation getSpecialOperation() {
		return specialOperation;
	}

	public void setSpecialOperation(SpecialOperation specialOperation) {
		this.specialOperation = specialOperation;
	}

	public TerminationReason getTerminationReason() {
		return terminationReason;
	}

	public void setTerminationReason(TerminationReason terminationReason) {
		this.terminationReason = terminationReason;
	}

	protected Activation getActivation() {
		return activation;
	}

	protected void setActivation(Activation activation) {
		this.activation = activation;
	}

	public MHDataSource getDataSource() {
		return dataSource;
	}

	public void setDataSource(MHDataSource dataSource) {
		this.dataSource = dataSource;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("country", this.country);
		builder.append("deploymentBeginDate", this.deploymentBeginDate);
		builder.append("deploymentEndDate", this.deploymentEndDate);
		builder.append("specialOperation", this.specialOperation);		
		builder.append("terminationReason", this.terminationReason);		
		builder.append("dataSource", this.dataSource);		
	}
	
}
