/*******************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.ee;

// Java classes

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * This is one of the classes of the Business Object Model (BOM). This class
 * represents a Conflict Experience.
 * 
 * Note: This class should be used only to build conflict experience objects with
 * conflict locations other than OEF, OIF, UNKNOWN OEF/OIF or UNSPECIFIED CONFLICT.
 * These objects are contained by the Military Service Site Record.
 * 
 * @author Andrew Pach
 * @version 3.0
 */
public class ConflictExperience extends AbstractCombatEpisode {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -7051499152031379214L;

	private MilitaryServiceSiteRecord militaryServiceSiteRecord = null;

	/**
	 * Default constructor.
	 */
	public ConflictExperience() {
		super();
	}

	public MilitaryServiceSiteRecord getMilitaryServiceSiteRecord() {
		return this.militaryServiceSiteRecord;
	}

	public void setMilitaryServiceSiteRecord(
			MilitaryServiceSiteRecord militaryServiceSiteRecord) {
        this.validateOwner(this.militaryServiceSiteRecord,militaryServiceSiteRecord);        
		this.militaryServiceSiteRecord = militaryServiceSiteRecord;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
	}
}