/*******************************************************************************
 * Copyright  2006 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.ee;

// Java classes

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.CombatPayType;
import gov.va.med.esr.common.model.lookup.CombatServiceLocation;
import gov.va.med.esr.common.model.lookup.CombatServiceSource;
import gov.va.med.esr.common.model.lookup.MsdsCountry;
import gov.va.med.esr.common.model.person.Person;

/**
 * This is one of the classes of the Business Object Model (BOM). This class
 * represents a Combat Service Record which is contained by a Person.
 * 
 * @author Muddaiah Ranga
 * @version 4.0
 */
public class CombatService extends AbstractKeyedEntity {

    private static final long serialVersionUID = 7891483523534360406L;

    private MilitaryService militaryService;
    
    private MsdsCountry msdsCountry;
    private ImpreciseDate payStartDate;
    private ImpreciseDate payEndDate;
    private CombatServiceSource combatServiceSource;
    private CombatPayType combatPayType;
    
	/**
	 * Default constructor.
	 */
	public CombatService() {
		super();
	}
    
	public MsdsCountry getMsdsCountry() {
        return msdsCountry;
    }

    public void setMsdsCountry(MsdsCountry msdsCountry) {
        this.msdsCountry = msdsCountry;
    }
    
	public ImpreciseDate getPayEndDate() {
        return payEndDate;
    }

    public void setPayEndDate(ImpreciseDate payEndDate) {
        this.payEndDate = payEndDate;
    }

    public ImpreciseDate getPayStartDate() {
        return payStartDate;
    }

    public void setPayStartDate(ImpreciseDate payStartDate) {
        this.payStartDate = payStartDate;
    }
    
    public CombatServiceSource getCombatServiceSource() {
        return combatServiceSource;
    }

    public void setCombatServiceSource(CombatServiceSource combatServiceSource) {
        this.combatServiceSource = combatServiceSource;
    }

    public MilitaryService getMilitaryService() {
        return militaryService;
    }

    public void setMilitaryService(MilitaryService militaryService) {
        this.validateOwner(this.militaryService,militaryService);        
        this.militaryService = militaryService;
    }
    
    
    public CombatPayType getCombatPayType() {
		return combatPayType;
	}

	public void setCombatPayType(CombatPayType combatPayType) {
		this.combatPayType = combatPayType;
	}

	/**
     * This getter returns the person object that is stored in the military
     * service parent object.
     * 
     * @return The person who is associated with this military service site
     *         record.
     */
    private Person getPerson() {
        return (this.militaryService == null) ? null : this.militaryService.getPerson();
    }

    /**
     * This setter doesn't actually set the person object since we are relying on
     * getting it from the parent. Instead, it sets the military service back
     * reference based on the person being passed in. This is because this setter
     * is only called by Hibernate and we want to maintain a back reference to
     * the parent military service object. If we don't set it here, there is no
     * other easy place to set it. Note that although a MilitaryServiceSiteRecord
     * is contained by a MilitaryService object, the database stores all site
     * record information in the MILITARY_SERVICE table which is contained
     * directly by PERSON (i.e. there is no middle table associated with the
     * MilitaryService object).
     * 
     * @param person
     *           The person back reference.
     */
    private void setPerson(Person person) {
        this.militaryService = (person == null) ? null : person.getMilitaryService();
    }
    
	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder.append("payStartDate", this.payStartDate)
                .append("payEndDate", this.payEndDate)
                .append("msdsCountry", this.msdsCountry)
                .append("combatServiceSource", this.combatServiceSource));
	}
}