/*******************************************************************************
 * Copyright  2006 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.ee;

// Java classes

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.esr.common.model.lookup.CombatPayType;
import gov.va.med.esr.common.model.lookup.OEFOIFSource;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;

/**
 * This is one of the classes of the Business Object Model (BOM). This class
 * represents a Combat Episode.
 * 
 * Note: This class should be used only to build OEF/OIF combat episode objects with
 * conflict locations OEF, OIF, UNKNOWN OEF/OIF or UNSPECIFIED CONFLICT.
 * These objects are contained by the Person.
 *  
 * @author Muddaiah Ranga
 * @version 4.0
 */
public class CombatEpisode extends AbstractCombatEpisode {
    
    private static final long serialVersionUID = 8517277139966075694L;

    private MilitaryService militaryService;
    
    private CombatPayType combatPayType;
    
    private OEFOIFSource OEFOIFSource;
    
    private VAFacility OEFOIFStationNumber;

	/**
	 * Default constructor.
	 */
	public CombatEpisode() {
		super();
	}

    public CombatPayType getCombatPayType() {
        return combatPayType;
    }

    public void setCombatPayType(CombatPayType combatPayType) {
        this.combatPayType = combatPayType;
    }

    public OEFOIFSource getOEFOIFSource() {
        return OEFOIFSource;
    }

    public void setOEFOIFSource(OEFOIFSource source) {
        OEFOIFSource = source;
    }

    public VAFacility getOEFOIFStationNumber() {
        return OEFOIFStationNumber;
    }

    public void setOEFOIFStationNumber(VAFacility stationNumber) {
        OEFOIFStationNumber = stationNumber;
    }

    public MilitaryService getMilitaryService() {
        return militaryService;
    }

    public void setMilitaryService(MilitaryService militaryService) {
        this.validateOwner(this.militaryService,militaryService);        
        this.militaryService = militaryService;
    }
    
    /**
     * This getter returns the person object that is stored in the military
     * service parent object.
     * 
     * @return The person who is associated with this military service site
     *         record.
     */
    private Person getPerson() {
        return (this.militaryService == null) ? null : this.militaryService.getPerson();
    }

    /**
     * This setter doesn't actually set the person object since we are relying on
     * getting it from the parent. Instead, it sets the military service back
     * reference based on the person being passed in. This is because this setter
     * is only called by Hibernate and we want to maintain a back reference to
     * the parent military service object. If we don't set it here, there is no
     * other easy place to set it. Note that although a MilitaryServiceSiteRecord
     * is contained by a MilitaryService object, the database stores all site
     * record information in the MILITARY_SERVICE table which is contained
     * directly by PERSON (i.e. there is no middle table associated with the
     * MilitaryService object).
     * 
     * @param person
     *           The person back reference.
     */
    private void setPerson(Person person) {
        this.militaryService = (person == null) ? null : person.getMilitaryService();
    }
    
	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder.append("combatPayType", this.combatPayType)
                .append("OEFOIFSource", this.OEFOIFSource)
                .append("OEFOIFStationNumber", this.OEFOIFStationNumber));
	}
}