/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.ee;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
//  Import third party library classes
//----------------------------------------------------------------------------
import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;

/**
 * @author Commons Team
 * @version 1.0
 */
public abstract class ClinicalDetermination
    extends AbstractKeyedEntity
{
    private static final long serialVersionUID = -1370346746640850300L;
    /**
     * Creates a new ClinicalDetermination object.
     */
    public ClinicalDetermination()
    {
        super();
    }

    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------

    public Person getPerson() {
        return this.person;
    }
    
    public void setPerson(Person person) {
        this.validateOwner(this.person,person);
        this.person = person;
    }

    public VAFacility getDeterminationFacility()
    {
        return this.determinationFacility;
    }

    public void setDeterminationFacility(VAFacility determinationFacility)
    {
        this.determinationFacility = determinationFacility;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder);

        builder.append("determinationDate", this.determinationFacility);
    }

    //----------------------------------------------------------------------------
    // Package protected method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Protected method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Private method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // All attributes that are not static
    //----------------------------------------------------------------------------

    /**
     * @hibernate.many-to-one class="gov.va.med.esr.common.model.person.Person"
     *                        not-null="true" insert="true" update="false"
     * @hibernate.column name="PARTY_ID"
     */
    private Person person = null;

    /**
     * Facility making determination is defined as the facility that the
     * clinical determination was performed and decided at. The VA facilities
     * table will be used to link the actual station number.
     * 
     * @hibernate.many-to-one class="gov.va.med.esr.common.model.party.VAFacility"
     *                        cascade="none" insert="true" update="true"
     * @hibernate.column name="RECORD_ORIGIN_ID"
     */
    private VAFacility determinationFacility = null;

} //  End of ClinicalDetermination Class
