/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.ee;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.EntityKey;

import gov.va.med.esr.common.model.lookup.CDDeterminationMethod;

/**
 * @author Commons Team
 * @version 1.0
 */
public class CatastrophicDisability
    extends ClinicalDetermination
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -1123826294937114608L;

	/**
     * Creates a new CatastrophicDisability object.
     */
    public CatastrophicDisability()
    {
        super();
    }

    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------

    public Date getReviewDate()
    {
        return this.reviewDate;
    }

    public void setReviewDate(Date reviewDate)
    {
        this.reviewDate = reviewDate;
    }

    public Date getDecisionDate()
    {
        return this.decisionDate;
    }

    public void setDecisionDate(Date decisionDate)
    {
        this.decisionDate = decisionDate;
    }

    public Date getVeteranRequestedCDReviewDate()
    {
        return this.veteranRequestedCDReviewDate;
    }

    public void setVeteranRequestedCDReviewDate(Date veteranRequestedCDReviewDate)
    {
        this.veteranRequestedCDReviewDate = veteranRequestedCDReviewDate;
    }
    public Date getFacilityInitiatedCDReviewDate()
    {
        return this.facilityInitiatedCDReviewDate;
    }

    public void setFacilityInitiatedCDReviewDate(Date facilityInitiatedCDReviewDate)
    {
        this.facilityInitiatedCDReviewDate = facilityInitiatedCDReviewDate;
    }
    public Date getVeteranWasNotifiedCDDate()
    {
        return this.veteranWasNotifiedCDDate;
    }

    public void setVeteranWasNotifiedCDDate(Date veteranWasNotifiedCDDate)
    {
        this.veteranWasNotifiedCDDate = veteranWasNotifiedCDDate;
    }
    
    public String getDeterminedBy()
    {
        return this.determinedBy;
    }

    public void setDeterminedBy(String determinedBy)
    {
        this.determinedBy = determinedBy;
    }

    public CDDeterminationMethod getDeterminationMethod()
    {
        return this.determinationMethod;
    }

    public void setDeterminationMethod(CDDeterminationMethod determinationMethod)
    {
        this.determinationMethod = determinationMethod;
    }

	public Boolean isCatastrophicallyDisabled() {
		return catastrophicallyDisabled;
	}

	/**
	 * @return Returns the catastrophicallyDisabled.
	 */
    public Boolean getCatastrophicallyDisabled() {
		return catastrophicallyDisabled;
	}
	/**
	 * @param catastrophicallyDisabled The catastrophicallyDisabled to set.
	 */
	public void setCatastrophicallyDisabled(Boolean catastrophicallyDisabled) {
		this.catastrophicallyDisabled = catastrophicallyDisabled;
	}
	
    /**
     * @return A collection of CDCondition object
     */
    public Set getConditions() {
        return Collections.unmodifiableSet(getInternalConditions());
    }

    public CDCondition getConditionByEntityKey(EntityKey identifier) {
        return (CDCondition) getEntityByEntityKey(getConditions(), identifier);
    }

    public CDCondition removeConditionByEntityKey(EntityKey identifier) {
        return (CDCondition) removeEntityByEntityKey(getInternalConditions(), identifier);
    }

    /**
     * Getter - for hibernate use only.
     * 
     * @return
     */
    private Set getInternalConditions() {
        if (this.internalConditions == null) {
            this.internalConditions = new HashSet();
        }
        return this.internalConditions;
    }

    /**
     * Setter - for hibernate use only.
     * 
     * @param conditions
     */
    private void setInternalConditions(Set conditions) {
        this.internalConditions = conditions;
    }

    /**
     * Add a CDCondition for this person. This method takes care of Bidirectional
     * setting of CDCondition's person.
     * 
     * @param condition
     */
    public void addCondition(CDCondition condition) {
        Validate.notNull(condition, "Null condition specified.");
        condition.setCatastrophicDisability(this);
        getInternalConditions().add(condition);
    }

    /**
     * Remove an CDCondition for this person. This method takes care of Bidirectional
     * setting of CDCondition's person.
     * 
     * @param condition
     */
    public void removeCondition(CDCondition condition) {
        Validate.notNull(condition, "Null condition specified.");
        getInternalConditions().remove(condition);
        condition.setCatastrophicDisability(null);
    }

    public void removeAllConditions() {
        getInternalConditions().clear();
    }
	
    /**
     * @return A collection of CDProcedure object
     */
    public Set getProcedures() {
        return Collections.unmodifiableSet(getInternalProcedures());
    }

    public CDProcedure getProcedureByEntityKey(EntityKey identifier) {
        return (CDProcedure) getEntityByEntityKey(getProcedures(), identifier);
    }

    public CDProcedure removeProcedureByEntityKey(EntityKey identifier) {
        return (CDProcedure) removeEntityByEntityKey(getInternalProcedures(), identifier);
    }

    /**
     * Getter - for hibernate use only.
     * 
     * @return
     */
    private Set getInternalProcedures() {
        if (this.internalProcedures == null) {
            this.internalProcedures = new HashSet();
        }
        return this.internalProcedures;
    }

    /**
     * Setter - for hibernate use only.
     * 
     * @param procedures
     */
    private void setInternalProcedures(Set procedures) {
        this.internalProcedures = procedures;
    }

    /**
     * Add a CDProcedure for this person. This method takes care of Bidirectional
     * setting of CDProcedure's person.
     * 
     * @param procedure
     */
    public void addProcedure(CDProcedure procedure) {
        Validate.notNull(procedure, "Null procedure specified.");
        procedure.setCatastrophicDisability(this);
        getInternalProcedures().add(procedure);
    }

    /**
     * Remove an CDProcedure for this person. This method takes care of Bidirectional
     * setting of CDProcedure's person.
     * 
     * @param procedure
     */
    public void removeProcedure(CDProcedure procedure) {
        Validate.notNull(procedure, "Null procedure specified.");
        getInternalProcedures().remove(procedure);
        procedure.setCatastrophicDisability(null);
    }

    public void removeAllProcedures() {
        getInternalProcedures().clear();
    }

    /**
     * @return A collection of CDdiagnosis object
     */
    public Set getDiagnoses() {
        return Collections.unmodifiableSet(getInternalDiagnoses());
    }

    public CDDiagnosis getDiagnosisByEntityKey(EntityKey identifier) {
        return (CDDiagnosis) getEntityByEntityKey(getDiagnoses(), identifier);
    }

    public CDDiagnosis removeDiagnosisByEntityKey(EntityKey identifier) {
        return (CDDiagnosis) removeEntityByEntityKey(getInternalDiagnoses(), identifier);
    }

    /**
     * Getter - for hibernate use only.
     * 
     * @return
     */
    private Set getInternalDiagnoses() {
        if (this.internalDiagnoses == null) {
            this.internalDiagnoses = new HashSet();
        }
        return this.internalDiagnoses;
    }

    /**
     * Setter - for hibernate use only.
     * 
     * @param diagnoses
     */
    private void setInternalDiagnoses(Set diagnoses) {
        this.internalDiagnoses = diagnoses;
    }

    /**
     * Add a CDDiagnosis for this person. This method takes care of Bidirectional
     * setting of CDDiagnosis's person.
     * 
     * @param diagnosis
     */
    public void addDiagnosis(CDDiagnosis diagnosis) {
        Validate.notNull(diagnosis, "Null diagnosis specified.");
        diagnosis.setCatastrophicDisability(this);
        getInternalDiagnoses().add(diagnosis);
    }

    /**
     * Remove an CDDiagnosis for this person. This method takes care of Bidirectional
     * setting of CDDiagnosis's person.
     * 
     * @param diagnosis
     */
    public void removeDiagnosis(CDDiagnosis diagnosis) {
        Validate.notNull(diagnosis, "Null diagnosis specified.");
        getInternalDiagnoses().remove(diagnosis);
        diagnosis.setCatastrophicDisability(null);
    }

    public void removeAllDiagnoses() {
        getInternalDiagnoses().clear();
    }

    // Add CD Descriptors
    public Set<CDDescriptor> getCDDescriptors() {
        return Collections.unmodifiableSet(getInternalCDDescriptors());
    }

    public CDDescriptor getCDDescriptorByEntityKey(EntityKey identifier) {
        return (CDDescriptor) getEntityByEntityKey(getCDDescriptors(), identifier);
    }

    public CDDescriptor removeCDDescriptorByEntityKey(EntityKey identifier) {
        return (CDDescriptor) removeEntityByEntityKey(getInternalCDDescriptors(), identifier);
    }

 
    private Set<CDDescriptor> getInternalCDDescriptors() {
        if (this.internalCDDescriptors == null) {
            this.internalCDDescriptors = new HashSet<CDDescriptor>();
        }
        return this.internalCDDescriptors;
    }

    private void setInternalCDDescriptors(Set<CDDescriptor> descriptors) {
        this.internalCDDescriptors = descriptors;
    }

    public void addCDDescriptor(CDDescriptor descriptor) {
        Validate.notNull(descriptor, "Null descriptor specified.");
        descriptor.setCatastrophicDisability(this);
        getInternalCDDescriptors().add(descriptor);
    }

    public void removeCDDescriptor(CDDescriptor descriptor) {
        Validate.notNull(descriptor, "Null descriptor specified.");
        getInternalCDDescriptors().remove(descriptor);
        descriptor.setCatastrophicDisability(null);
    }

    public void removeAllCDDescriptors() {
        getInternalCDDescriptors().clear();
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder);

        builder.append("reviewDate", this.reviewDate);
        builder.append("decisionDate", this.decisionDate);
        builder.append("veteranRequestedCDReviewDate", this.veteranRequestedCDReviewDate);
        builder.append("facilityInitiatedCDReviewDate", this.facilityInitiatedCDReviewDate);
        builder.append("veteranWasNotifiedCDDate", this.veteranWasNotifiedCDDate);
        builder.append("determinedBy", this.determinedBy);
        builder.append("determinationMethod", this.determinationMethod);
        builder.append("catastrophicallyDisabled", this.catastrophicallyDisabled);
   }

    /**
     * Review date is defined as the date of the Catastrophically Disabled
     * evaluation. Either by medical record or by physical exam.
     * 
     */
    private Date reviewDate = null;
    
    private Date decisionDate = null;

    private Date veteranRequestedCDReviewDate = null;
    
    private Date facilityInitiatedCDReviewDate = null;
    
    private Date veteranWasNotifiedCDDate = null;
    
    /**
     * Decided by is defined as the name of the Chief of Staff or Designee
     * making the Catastrophically Disabled decision. Free text.
     * 
     */
    private String determinedBy = null;

    /**
     * Determination method is defined as the method used to perform
     * Catastrophically Disabled evaluation. Values include: Medical Record
     * Review, Physical Exam.
     * 
     */
    private CDDeterminationMethod determinationMethod = null;

    private Boolean catastrophicallyDisabled = null; 
	
    private Set internalDiagnoses = null;

    private Set internalProcedures = null;

    private Set internalConditions = null;
    
    private Set<CDDescriptor> internalCDDescriptors = null;    


} //  End of CatastrophicDisability Class
