/*
 * ApplicationCancellation.java
 * Copyright 2004,
 * Veterans Health Administration
 * All rights reserved.
 */

// Generated 11/26/2004 10:14:55 AM 
package gov.va.med.esr.common.model.ee;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.lookup.CancelDeclineNotProcessedReason;
import gov.va.med.esr.common.model.lookup.CancelDeclineReason;
import gov.va.med.esr.common.model.person.Person;

/**
 * @author Commons Team
 * @hibernate.mapping auto-import="true" default-cascade="all"
 * @hibernate.class table="CANCEL_DECLINE"
 *  
 */
public class CancelDecline extends AbstractKeyedEntity {

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6657285462564057349L;

	/**
     * Creates a new ApplicationCancellation object.
     */
    public CancelDecline() {
        super();
    }

    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.validateOwner(this.person,person);
        this.person = person;
    }

    public CancelDeclineReason getReason() {
        return this.reason;
    }

    public void setReason(CancelDeclineReason reason) {
        this.reason = reason;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public CancelDeclineNotProcessedReason getReasonNotProcessed() {
        return this.reasonNotProcessed;
    }

    public void setReasonNotProcessed(
            CancelDeclineNotProcessedReason reasonCancelDeclineNotProcessed) {
        this.reasonNotProcessed = reasonCancelDeclineNotProcessed;
    }

    public Boolean getCancelDeclineIndicator() {
        return this.cancelDeclineIndicator;
    }

    public void setCancelDeclineIndicator(Boolean ind) {
        this.cancelDeclineIndicator = ind;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("reason", this.reason);
        builder.append("remarks", this.remarks);
        builder.append("effectiveDate", this.effectiveDate);
        builder.append("reasonNotProcessed", this.reasonNotProcessed);
    }

    //----------------------------------------------------------------------------
    // Package protected method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Protected method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Private method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // All attributes that are not static
    //----------------------------------------------------------------------------

    /**
     * @hibernate.many-to-one class="gov.va.med.esr.common.model.person.Person"
     *                        not-null="true" insert="true" update="false"
     * @hibernate.column name="PARTY_ID"
     */
    private Person                          person                 = null;

    /**
     * @hibernate.many-to-one class="gov.va.med.esr.common.model.lookup.CancelDeclineReason"
     *                        cascade="none" not-null="true" insert="true"
     *                        update="true"
     * @hibernate.column name="CAN_DEC_REASON_ID"
     */
    private CancelDeclineReason             reason                 = null;

    /**
     * @hibernate.property insert="true" update="true" column="COMMENT_TEXT"
     *                     length="200"
     */
    private String                          remarks                = null;

    /**
     * @hibernate.property insert="true" update="true" column="EFFECTIVE_DATE"
     */
    private Date                            effectiveDate          = null;

    /**
     * @hibernate.many-to-one class="gov.va.med.esr.common.model.lookup.CancelDeclineNotProcessedReason"
     *                        cascade="none" not-null="true" insert="true"
     *                        update="true"
     * @hibernate.column name="CAN_DEC_REQ_PROCESS_STATE_ID"
     */
    private CancelDeclineNotProcessedReason reasonNotProcessed     = null;

    private Boolean                         cancelDeclineIndicator = null;

} //  End of ApplicationCancellation Class
