package gov.va.med.esr.common.model.ee;


import gov.va.med.esr.common.model.lookup.CampLejeuneVerificationType;
import gov.va.med.fw.model.AbstractKeyedEntity;

import org.apache.commons.lang.builder.ToStringBuilder;

public class CampLejeuneVerificationMethod extends AbstractKeyedEntity  {


	
		/**
		 * An instance of serialVersionUID
		 */
	   private static final long serialVersionUID = -44609728276070080L;
		
	    private CampLejeuneVerificationType	verificationType;
	    private SpecialFactor specialFactor;
	    
	    private int hashValue = 0;
	    
	  
	    
	    
		/**
		 * Creates a new MonetaryBenefit object.
		 */
		public CampLejeuneVerificationMethod() {
			super();
		}

		// ----------------------------------------------------------------------------
		// Public method(s)
		// ----------------------------------------------------------------------------
		
		/* (non-Javadoc)
		 * 
		 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
		 */
		protected void buildToString(ToStringBuilder builder) {
			super.buildToString(builder);
	        builder.append("verificationType", this.verificationType);
//	        builder.append("specialFactor", this.specialFactor); //cause stackoverflow
	       
		}

		public CampLejeuneVerificationType getVerificationType() {
			return verificationType;
		}

		public void setVerificationType(CampLejeuneVerificationType verificationType) {
			this.verificationType = verificationType;
		}

		public SpecialFactor getSpecialFactor() {
			return specialFactor;
		}

		public void setSpecialFactor(SpecialFactor specialFactor) {
			this.validateOwner(this.specialFactor, specialFactor);
			this.specialFactor = specialFactor;
		}

	   public boolean equals(Object rhs)
	   {
		   
	       if (rhs == null)
	           return false;
	       if (rhs == this)
	    	   return true;
	       if (rhs.getClass() != getClass()) 
	           return false; 

	       
	       CampLejeuneVerificationMethod that = (CampLejeuneVerificationMethod) rhs;
	       if (isEqual(this.getIdentifier(), that.getIdentifier()) &&
	    		   isEqual(this.verificationType,that.verificationType) &&
	    		   isEqual(this.specialFactor,that.specialFactor))
	       {
	           return true;
	       }
	           
	       return false;
	   }
	   
	   private boolean isEqual(Object a, Object b)
	   {
		   if (a == null)
		   {
			   return (b == null) ? true : false;
		   } else
		   {
			   return (b == null) ? false : a.equals(b);
		   }
	   }

	   /**
	    * Implementation of the hashCode method conforming to the Bloch pattern with
	    * the exception of array properties (these are very unlikely primary key types).
	    * @return int
	    */
	   public int hashCode()
	   {
	       if (this.hashValue == 0)
	       {
	           int result = 17;
	           int idValue = this.getIdentifier() == null ? 0 : this.getIdentifier().hashCode();
	           result = result * 37 + idValue;
	           if(verificationType != null){
	        	   result = result * 37 + verificationType.hashCode();        	   
	           }           
	           
	           if (this.specialFactor != null)
	           {
	        	   result = result * 37 + specialFactor.hashCode();
	           }

	           this.hashValue = result;
	       }
	       return this.hashValue;
	   }
		
	}