package gov.va.med.esr.common.model.ee;

// ----------------------------------------------------------------------------
// Import java classes
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// Import third party library classes
// ----------------------------------------------------------------------------
import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.lookup.AffectedExtremity;
import gov.va.med.esr.common.model.lookup.Procedure;

/**
 * @author Commons Team
 * @version 1.0
 */
public class CDProcedure extends AbstractKeyedEntity {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 8953337665576403552L;

	/**
	 * Creates a new CDProcedure object.
	 */
	public CDProcedure() {
		super();
	}

	// ----------------------------------------------------------------------------
	// Public method(s)
	// ----------------------------------------------------------------------------

	public Procedure getProcedure() {
		return this.procedure;
	}

	public void setProcedure(Procedure procedure) {
		this.procedure = procedure;
	}

	public AffectedExtremity getAffectedExtremity() {
		return this.affectedExtremity;
	}

	public void setAffectedExtremity(AffectedExtremity affectedExtremity) {
		this.affectedExtremity = affectedExtremity;
	}

	public CatastrophicDisability getCatastrophicDisability() {
		return this.catastrophicDisability;
	}

	public void setCatastrophicDisability(
			CatastrophicDisability catastrophicDisability) {
		validateOwner(this.catastrophicDisability, catastrophicDisability);
		this.catastrophicDisability = catastrophicDisability;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);

		builder.append("procedure", this.procedure);
		builder.append("affectedExtremity", this.affectedExtremity);
	}

	// ----------------------------------------------------------------------------
	// Private method(s)
	// ----------------------------------------------------------------------------

	// ----------------------------------------------------------------------------
	// All attributes that are not static
	// ----------------------------------------------------------------------------

	/**
	 * @hibernate.many-to-one class="CatastrophicDisability" not-null="true"
	 *                        insert="true" update="false"
	 * @hibernate.column name="CLINICAL_FACTOR_ID"
	 */
	private CatastrophicDisability catastrophicDisability = null;

	/**
	 * CD procedure is defined as the specific procedure performed on the veteran
	 * that provides a reason for him/her to potentially qualify for a
	 * Catastrophic Disability. The veteran shall be determined Catastrophically
	 * Disabled if he/she has two of the following procedures (ICD-9 Procedure
	 * Codes 84.03 through 84.19) and/or certain CPT Codes provided the two
	 * procedures were not on the same limb. The user may enter in any of the
	 * following ICD-9 codes: 84.03 Amputation through hand 84.04 Disarticulation
	 * of wrist 84.05 Amputation through forearm 84.05 Disarticulation of elbow
	 * 84.06 Amputation through elbow 84.07 Amputation through humerus 84.08
	 * Shoulder disarticulation 84.09 Forequarter amputation 84.10 Lower limb
	 * amputation not otherwise specified 84.11 Amputation of great toe 84.12
	 * Amputation through foot 84.13 Disarticulation of ankle 84.14 Amputation
	 * through malleoli 84.15 Other amputation below knee 84.16 Disarticulation
	 * of knee 84.17 Above knee amputation 84.18 Disarticulation of hip 84.19
	 * Hindquarter amputation. The user may enter in any of the following V
	 * codes: (future requirement, not at the sites currently- so OOS for Dec
	 * 01): V49.63 Hand amputation status V49.64 Wrist Amputation status V49.65
	 * Below El bow Amputation Status V49.66 Above Elbow Amputation Status V49.67
	 * Shoulder Amputation Status V49.70 Unspecified Lower Limb Amputation Status
	 * V49.71 Great Toe Amputation Status V49.73 Foot Amputation Status V49.74
	 * Ankle Amputation Status V49.75 Below knee Amputation Status V49.76 Above
	 * Knee Amputation Status V49.77 Hip Amputation Status The user may enter in
	 * any of the following CLPT Codes: 23900 Amputation of Arm & Girdle 23920
	 * Amputation at shoulder Joint 24900 Amputation of Upper Arm 24920
	 * Amputation of Upper Arm 24999 Upper Arm/Elbow Surgery 25900 Amputation of
	 * Forearm 25905 Amputation of Forearm 25920 Amputate Hand at Wrist 25927
	 * Amputation of Hand 27290 Amputation of Leg at Hip 27295 Amputation of Leg
	 * at Hip 27598 Amputation of Lower Leg at Knee 27880 Amputation of Lower Leg
	 * 27882 Amputation of Lower Leg 27888 Amputation of foot at ankle 27889
	 * Amputation of foot at ankle 28800 Amputation of midfoot2 8805 Amputation
	 * through Metatarsal 28810 Amputation Toe & Metatarsal 28820 Amputation of
	 * Toe. The same procedure code may be entered on the same person twice, as
	 * long as the affected extremity for each entry is different. Any one
	 * procedure code may not be entered in more than two times.
	 */
	private Procedure procedure = null;

	/**
	 * Affected extremity refers to the data collected for Catastrophically
	 * Disabled clinical determination. It is an affected extremity that is valid
	 * for the procedure.This is a set of codes: 'RUE' FOR Right Upper Extremity;
	 * 'LUE' FOR Left Upper Extremity 'RLE' FOR Right Lower Extremity; 'LLE' FOR
	 * Left Lower Extremity; Procedure codes indicate upper or lower extremity so
	 * for each procedure code only applicable affected extremities will be
	 * valid.(i.e. 27880 amputation of lower leg can have either RLE or LLE
	 * entered as an appropriate affected extremity)
	 */
	private AffectedExtremity affectedExtremity = null;

} // End of CDProcedure Class
