package gov.va.med.esr.common.model.ee;

// ----------------------------------------------------------------------------
// Import java classes
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// Import third party library classes
// ----------------------------------------------------------------------------
import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.lookup.Diagnosis;

/**
 * @author Commons Teams
 * @version 1.0
 */
public class CDDiagnosis extends AbstractKeyedEntity {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 446344989785271271L;

	/**
	 * Creates a new CDDiagnosis object.
	 */
	public CDDiagnosis() {
		super();
	}

	// ----------------------------------------------------------------------------
	// Public method(s)
	// ----------------------------------------------------------------------------

	public Diagnosis getDiagnosis() {
		return this.diagnosis;
	}

	public void setDiagnosis(Diagnosis diagnosis) {
		this.diagnosis = diagnosis;
	}

	public CatastrophicDisability getCatastrophicDisability() {
		return this.catastrophicDisability;
	}

	public void setCatastrophicDisability(
			CatastrophicDisability catastrophicDisability) {
		validateOwner(this.catastrophicDisability, catastrophicDisability);
		this.catastrophicDisability = catastrophicDisability;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);

		builder.append("diagnosis", this.diagnosis);
	}

	// ----------------------------------------------------------------------------
	// Private method(s)
	// ----------------------------------------------------------------------------

	// ----------------------------------------------------------------------------
	// All attributes that are not static
	// ----------------------------------------------------------------------------

	private CatastrophicDisability catastrophicDisability = null;

	/**
	 * CD diagnosis is the specified Catastrophically Disabled reason and must be
	 * a diagnosis. Only the following ICD-9 codes may be entered: 344.00
	 * Quadriplegia, Unspecified 344.01 Quadriplegia, C1-C4, Complete 344.02
	 * Quadriplegia, C1-C4, Incomplete 344.04 Quadriplegia, C5-C7, Incomplete
	 * 344.09 Other Quadriplegia,Paraplegia 369.4 Blindness 780.03 Persistent
	 * Vegetative state.
	 */
	private Diagnosis diagnosis = null;
}
