package gov.va.med.esr.common.model.ee;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.esr.common.model.lookup.DescriptorType;
import gov.va.med.esr.common.model.lookup.VAFacility;

/**
 * 
 * @author DNS   ruizc
 *
 */
public class CDDescriptor extends AbstractKeyedEntity {

	private static final long serialVersionUID = -4564250229950883626L;
	
	private CatastrophicDisability catastrophicDisability = null;	
	private DescriptorType descriptorType = null;
	
	public CDDescriptor() {
		super();
	}

	public CatastrophicDisability getCatastrophicDisability() {
		return catastrophicDisability;
	}

	public void setCatastrophicDisability(
			CatastrophicDisability catastrophicDisability) {
		this.validateOwner(this.catastrophicDisability, catastrophicDisability);		
		this.catastrophicDisability = catastrophicDisability;
	}

	public DescriptorType getDescriptorType() {
		return descriptorType;
	}

	public void setDescriptorType(DescriptorType descriptorType) {
		this.descriptorType = descriptorType;
	}

	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);

		builder.append("descriptorType", this.descriptorType);
	}	
}
