package gov.va.med.esr.common.model.ee;

// ----------------------------------------------------------------------------
// Import java classes
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// Import third party library classes
// ----------------------------------------------------------------------------
import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.lookup.Condition;
import gov.va.med.esr.common.model.lookup.PermanentIndicator;

/**
 * @author Commons Teams
 * @version 1.0
 */
public class CDCondition extends AbstractKeyedEntity {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6128581310884822747L;

	/**
	 * Creates a new CDCondition object.
	 */
	public CDCondition() {
		super();
	}

	// ----------------------------------------------------------------------------
	// Public method(s)
	// ----------------------------------------------------------------------------

	public Condition getCondition() {
		return this.condition;
	}

	public void setCondition(Condition condition) {
		this.condition = condition;
	}

	public Integer getScore() {
		return this.score;
	}

	public void setScore(Integer score) {
		this.score = score;
	}

	public PermanentIndicator getPermanentIndicator() {
		return this.permanentIndicator;
	}

	public void setPermanentIndicator(PermanentIndicator permanentIndicator) {
		this.permanentIndicator = permanentIndicator;
	}

	public CatastrophicDisability getCatastrophicDisability() {
		return this.catastrophicDisability;
	}

	public void setCatastrophicDisability(
			CatastrophicDisability catastrophicDisability) {
		this.validateOwner(this.catastrophicDisability, catastrophicDisability);
		this.catastrophicDisability = catastrophicDisability;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);

		builder.append("condition", this.condition);
		builder.append("score", this.score);
		builder.append("permanentIndicator", this.permanentIndicator);
	}

	// ----------------------------------------------------------------------------
	// Private method(s)
	// ----------------------------------------------------------------------------

	// ----------------------------------------------------------------------------
	// All attributes that are not static
	// ----------------------------------------------------------------------------

	private CatastrophicDisability catastrophicDisability = null;

	/**
	 * CD condition is determined if he/she has one of the following conditions:
	 * Dependent in three or more ADLs, with at least three of the dependencies
	 * being permanent, using the Katz Scale. A score of 10 or lower using the
	 * Folstein Mini-Mental State Examination. A score of 2 or lower on at least
	 * 4 of the 13 motor items using the Functional Independence Measure (FIM) A
	 * score of 30 or lower using the Global Assessment of Functions in (GAF)
	 * Valid values for this attribute are: (FOLS)-FOLSTEIN MINI-MENTAL STATE
	 * EXAM (FIM)-FUNCTIONAL INDEPENDENCE MEASURE (GAF)-GLOBAL ASSESSMENT OF
	 * FUNCTIONING (KATZ)-KATZ SCALE.
	 */
	private Condition condition = null;

	/**
	 * Score is based on the following and contingent on which CD condition was
	 * selected (FOLS, FIM, GAF, or KATZ). Each one will have a score associated
	 * with it. Folstein Mini-Mental State Examination (FOLS) is a number between
	 * 0 - 30, on the Folstein.Mini-Mental State Examination (MMSE). Functional
	 * Independence Measure:The FIM contains 18 measures in 6 domains. The 13
	 * MOTOR ITEMS are in 4 domains:- self-care,- sphincter control, - transfers,
	 * and- locomotion.The value in this field is based on the number of MOTOR
	 * items for which the veteran received a score of 2 or lower. FIMS Score is
	 * 0-13.The Katz Index of Activities of Daily Living (ADLs) assigns a number
	 * from 1 to 3 in each of 6 activities. 1 is dependent, 2 is an intermediate
	 * limitation, and 3 is independent. The Katz Index may be used to determine
	 * whether a veteran is catastrophically disabled.This field must contain the
	 * number of permanent ADLs for which the veteran received a score of 1
	 * (dependent). It is NOT the overall score on theKATZ test (which can range
	 * from 0 to 6.) GAF score is a number between 1 and 100.
	 */
	private Integer score;

	/**
	 * Permanent Indicator indicates if the specific CD condition is a permanent
	 * one. This is a set of codes: 1- FOR PERMANENT; 2- FOR NOT PERMANENT; 3-
	 * FOR UNKNOWN
	 */
	private PermanentIndicator permanentIndicator = null;

}