package gov.va.med.esr.common.model.ee;

// ----------------------------------------------------------------------------
// Import java classes
// ----------------------------------------------------------------------------
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.lookup.BenefitType;
import gov.va.med.esr.common.model.lookup.ApplicationMethod;
import gov.va.med.esr.common.model.person.Person;

/**
 * @author Commons Team
 * @version 1.0
 */
public class Application extends AbstractKeyedEntity {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 5697850999268339389L;

	private Person person = null;

	private Date applicationDate = null;

    BenefitType benefitType = null;
   
    private ApplicationMethod applicationMethod = null;

    /* VOA, VISTA, null*/
    //AppDataSource ???
    
	/**
	 * Creates a new Application object.
	 */
	public Application() {
		super();
	}

	// ----------------------------------------------------------------------------
	// Public method(s)
	// ----------------------------------------------------------------------------

	public Person getPerson() {
		return this.person;
	}

	public void setPerson(Person person) {
		this.validateOwner(this.person, person);
		this.person = person;
	}

	public Date getApplicationDate() {
		return this.applicationDate;
	}

	public void setApplicationDate(Date applicationDate) {
		this.applicationDate = applicationDate;
	}

	public BenefitType getBenefitType() {
        return benefitType;
    }

    public void setBenefitType(BenefitType benefitType) {
        this.benefitType = benefitType;
    }

   /**
	 * @deprecated This attribute no longer applies. This method currenly returns
	 *             null and will be dropped.
	 * @return
	 */
	public Date getEffectiveDate() {
		return null;
	}

	/**
	 * @deprecated This attribute no longer applies. This method currenly does no
	 *             op and will be dropped.
	 * @param effectiveDate
	 */
	public void setEffectiveDate(Date effectiveDate) {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("applicationDate", this.applicationDate);
        builder.append("benefitType", this.benefitType);
	}

	public void setAppliactionMethod(ApplicationMethod appMethod) {
	   applicationMethod = appMethod;
	}
	
	public ApplicationMethod getApplicationMethod() {
	   return applicationMethod;
	}
 }
