/*******************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.ee;

// Java classes

// Library classes
import org.apache.commons.lang.builder.ToStringBuilder;

// Framework classes

// ESR classes
import gov.va.med.esr.common.model.lookup.AgentOrangeExposureLocation;
import gov.va.med.esr.common.model.lookup.Indicator;

/**
 * This is one of the classes of the Business Object Model (BOM). This class
 * represents an Agent Orange Exposure special factor.
 * 
 * @author Andrew Pach
 * @version 3.0
 */

public class AgentOrangeExposure extends SpecialFactor {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 3936499555010270713L;
	
	private AgentOrangeExposureLocation location = null;

	/**
	 * Default constructor.
	 */
	public AgentOrangeExposure() {
		super();
	}

	public AgentOrangeExposureLocation getLocation() {
		return this.location;
	}

	public void setLocation(AgentOrangeExposureLocation location) {
		this.location = location;
	}

	/**
	 * @return Returns the agentOrangeExposureIndicator.
	 */
	public Indicator getAgentOrangeExposureIndicator() {
		return specialFactorIndicator;
	}
	/**
	 * @param agentOrangeExposureIndicator The agentOrangeExposureIndicator to set.
	 */
	public void setAgentOrangeExposureIndicator(
			Indicator agentOrangeExposureIndicator) {
		this.specialFactorIndicator = agentOrangeExposureIndicator;
	}
	/**
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("location", this.location);
        builder.append("agentOrangeExposureIndicator", this.specialFactorIndicator);
	}
}
