package gov.va.med.esr.common.model.ee;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.collections.set.UnmodifiableSet;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.esr.common.model.lookup.MHDataSource;
import gov.va.med.esr.common.model.lookup.NamedContingency;
import gov.va.med.esr.common.model.lookup.SpecialOperation;
import gov.va.med.esr.common.model.lookup.TerminationReason;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.model.AbstractKeyedEntity;


/**
 * 
 * @author DNS   ruizc
 * @version 1.0
 *
 */
public class Activation extends AbstractKeyedEntity {

	/**
	 * 
	 */
	private static final long serialVersionUID = -550588469857190971L;

	// Special Operation Code
	private SpecialOperation specialOperation;
	
	private NamedContingency namedContingency;

	// Activation begin date
	private Date activationBeginDate;
	
	// Activation end date
	private Date activationEndDate;	
	
	private TerminationReason terminationReason;
	
	private MHDataSource dataSource;
	
	private MilitaryService militaryService;
	
	private Set internalDeployments = null;

	public Date getActivationBeginDate() {
		return activationBeginDate;
	}

	public void setActivationBeginDate(Date activationBeginDate) {
		this.activationBeginDate = activationBeginDate;
	}

	public Date getActivationEndDate() {
		return activationEndDate;
	}

	public void setActivationEndDate(Date activationEndDate) {
		this.activationEndDate = activationEndDate;
	}

	public MHDataSource getDataSource() {
		return dataSource;
	}

	public void setDataSource(MHDataSource dataSource) {
		this.dataSource = dataSource;
	}

	public SpecialOperation getSpecialOperation() {
		return specialOperation;
	}

	public void setSpecialOperation(SpecialOperation specialOperation) {
		this.specialOperation = specialOperation;
	}

	public TerminationReason getTerminationReason() {
		return terminationReason;
	}

	public void setTerminationReason(TerminationReason terminationReason) {
		this.terminationReason = terminationReason;
	}
	
	public void addAllDeployments(Set deployments) {
		if( deployments != null ) {
			for( Iterator i=deployments.iterator(); i.hasNext(); ) {
				Object record = i.next();
				if( record instanceof Deployment ) {
					this.addDeployment( (Deployment)record );
				}
			}
		}
	}	
	public void removeAllDeployments() {
		getInternalDeployments().clear();
	} 	
	public void addDeployment( Deployment deployment ) {
		Validate.notNull(deployment);     
		getInternalDeployments().add(deployment);
		deployment.setActivation(this);
	}	

	public Set getDeployments() {
		return UnmodifiableSet.decorate(this.getInternalDeployments());
	}	

	private void setInternalDeployments(Set internalDeployments) {
		this.internalDeployments = internalDeployments;
	}

	private Set getInternalDeployments() {
	        if (this.internalDeployments == null) {
	            this.internalDeployments = new HashSet();
	        }
	        return this.internalDeployments;
	    }

	public MilitaryService getMilitaryService() {
		return militaryService;
	}

	public void setMilitaryService(MilitaryService militaryService) {
		this.militaryService = militaryService;
	}
	
	public NamedContingency getNamedContingency() {
		return namedContingency;
	}

	public void setNamedContingency(NamedContingency namedContingency) {
		this.namedContingency = namedContingency;
	}

	public Person getPerson() {
	        return (this.militaryService == null) ? null : this.militaryService.getPerson();
	    }

	
	
	/* (non-Javadoc)
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("activationBeginDate", this.activationBeginDate);
		builder.append("activationEndDate", this.activationEndDate);		
		builder.append("dataSource", this.dataSource);
		builder.append("namedContingency", this.namedContingency);
		builder.append("specialOperation", this.specialOperation);
		builder.append("terminationReason", this.terminationReason);
	}

	/**
	 * This setter doesn't actually set the person object since we are relying on
	 * getting it from the parent. Instead, it sets the military service back
	 * reference based on the person being passed in. This is because this setter
	 * is only called by Hibernate and we want to maintain a back reference to
	 * the parent military service object. If we don't set it here, there is no
	 * other easy place to set it. Note that although a MilitaryServiceSiteRecord
	 * is contained by a MilitaryService object, the database stores all site
	 * record information in the MILITARY_SERVICE table which is contained
	 * directly by PERSON (i.e. there is no middle table associated with the
	 * MilitaryService object).
	 * 
	 * @param person
	 *           The person back reference.
	 */
	private void setPerson(Person person) {
		this.militaryService = (person == null) ? null : person.getMilitaryService();
	}	
}
