/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.ee;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentSource;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;

/**
 * AbstractEnrollment class contains the common attributes 
 * that may be required by received enrollment and enrollment determination.
 * 
 * @author DNS   MANSOG
 * @version 1.0
 */
public abstract class AbstractEnrollment
    extends AbstractKeyedEntity {
    
    private static final long serialVersionUID = -1370346746640850300L;
    private Person                     person                         = null;
    private EnrollmentPriorityGroup    priorityGroup                  = null;
    private EnrollmentPrioritySubGroup prioritySubGroup               = null;
    
    private EnrollmentPriorityGroup    initialPriorityGroup                  = null;
    private EnrollmentPrioritySubGroup initialPrioritySubGroup               = null;
    
    private EnrollmentSource           calculationSource              = null;
    private EnrollmentStatus           enrollmentStatus               = null;

    private Date                       enrollmentDate                 = null;
    private Date                       endDate                        = null;
    /*
     * Facility Received is defined as the facility that received the patient's
     * application for enrollment.
     */
    private VAFacility                 facilityReceived               = null;

    /*
     * Effective Date of Change is defined as the effective date of the
     * enrollment change. It is the date the enrollment status took affect and
     * not necessarily the date the system actually processed and assigned the
     * enrollment status.
     */
    private Date                       effectiveDate                  = null;

    /*
     * The enrollment can be overriden by the HEC user, instead
     * of being calculated. This attribute is to indicate if the
     * enrollment status is overriden by the HEC user.
     */
    private Boolean                    overridden                     = Boolean.FALSE;

    /**
     * Creates a new EnrollmentDetermination object.
     */
    public AbstractEnrollment() {
        super();
    }

    public Person getPerson() {
        return person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public Date getEnrollmentDate() {
        return this.enrollmentDate;
    }

    public void setEnrollmentDate(Date enrollmentDate) {
        this.enrollmentDate = enrollmentDate;
    }

    public EnrollmentPriorityGroup getPriorityGroup() {
        return this.priorityGroup;
    }

    public void setPriorityGroup(EnrollmentPriorityGroup priorityGroup) {
        this.priorityGroup = priorityGroup;
    }

    public EnrollmentPrioritySubGroup getPrioritySubGroup() {
        return this.prioritySubGroup;
    }

    public void setPrioritySubGroup(EnrollmentPrioritySubGroup prioritySubGroup) {
        this.prioritySubGroup = prioritySubGroup;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public EnrollmentSource getCalculationSource() {
        return this.calculationSource;
    }

    public void setCalculationSource(EnrollmentSource calculationSource) {
        this.calculationSource = calculationSource;
    }

    /**
     * @return Returns the facilityReceived.
     */
    public VAFacility getFacilityReceived() {
        return facilityReceived;
    }

    /**
     * @param facilityReceived
     *        The facilityReceived to set.
     */
    public void setFacilityReceived(VAFacility receivedFacility) {
        this.facilityReceived = receivedFacility;
    }

    /**
     * @param effectiveDate
     *        The effectiveDate to set.
     */
    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public EnrollmentStatus getEnrollmentStatus() {
        return this.enrollmentStatus;
    }

    public void setEnrollmentStatus(EnrollmentStatus status) {
        this.enrollmentStatus = status;
    }

    public Boolean getOverridden() {
        return this.overridden;
    }

    public void setOverridden(Boolean overridden) {
        this.overridden = overridden;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("enrollmentDate", this.enrollmentDate);
        builder.append("priorityGroup", this.priorityGroup);
        builder.append("prioritySubGroup", this.prioritySubGroup);
        builder.append("initalPriorityGroup", this.initialPriorityGroup);
        builder.append("initalPrioritySubGroup", this.initialPrioritySubGroup);
        builder.append("calculationSource", this.calculationSource);
        builder.append("facilityReceived", this.facilityReceived);
        builder.append("effectiveDate", this.effectiveDate);
        builder.append("endDate", this.endDate);
    }

	public EnrollmentPriorityGroup getInitialPriorityGroup() {
		return initialPriorityGroup;
	}

	public void setInitialPriorityGroup(EnrollmentPriorityGroup initialPriorityGroup) {
		this.initialPriorityGroup = initialPriorityGroup;
	}

	public EnrollmentPrioritySubGroup getInitialPrioritySubGroup() {
		return initialPrioritySubGroup;
	}

	public void setInitialPrioritySubGroup(
			EnrollmentPrioritySubGroup initialPrioritySubGroup) {
		this.initialPrioritySubGroup = initialPrioritySubGroup;
	}
}

