/*******************************************************************************
 * Copyright  2006 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.ee;

// Java classes

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.ConflictLocation;

/**
 * This is one of the classes of the Business Object Model (BOM). This class
 * is the base class for Combat Episodes.
 * 
 * @author Muddaiah Ranga
 * @version 4.0
 */
public abstract class AbstractCombatEpisode extends AbstractKeyedEntity {
    
    private static final long serialVersionUID = -1370346746640850300L;
    private ImpreciseDate startDate = null;

	private ImpreciseDate endDate = null;

	private ConflictLocation conflictLocation = null;

	/**
	 * Default constructor.
	 */
	public AbstractCombatEpisode() {
		super();
	}
    
	public ImpreciseDate getStartDate() {
		return this.startDate;
	}

	public void setStartDate(ImpreciseDate startDate) {
		this.startDate = startDate;
	}

	public ImpreciseDate getEndDate() {
		return this.endDate;
	}

	public void setEndDate(ImpreciseDate endDate) {
		this.endDate = endDate;
	}

	public ConflictLocation getConflictLocation() {
		return this.conflictLocation;
	}

	public void setConflictLocation(ConflictLocation conflictLocation) {
		this.conflictLocation = conflictLocation;
	}
    
	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder.append("startDate", this.startDate)
                .append("endDate", this.endDate)
                .append("conflictLocation", this.conflictLocation));
	}
}