/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.comms;

// Java classes
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.WaitType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * Address BOM
 * @author DNS   MANSOG
 * @version 1.0
 */
public class Waittime extends AbstractKeyedEntity {

	/**
	 * 
	 */
	private static final long serialVersionUID = 8087324060290888767L;
	private Person person;

	private String clinicStopcode;
	private String clinicStopcodeName;
	private int daysElapsed;
	private Date desiredAppointmentDate;
	private int recordResolvedInd;
	private VAFacility vaFacility;
	private Date waitlistStartDate;
	private WaitType waitType;


	public Person getPerson() {
		return person;
	}


	public void setPerson(Person person) {
		this.person = person;
	}


	public String getClinicStopcode() {
		return clinicStopcode;
	}


	public void setClinicStopcode(String clinicStopcode) {
		this.clinicStopcode = clinicStopcode;
	}


	public String getClinicStopcodeName() {
		return clinicStopcodeName;
	}


	public void setClinicStopcodeName(String clinicStopcodeName) {
		this.clinicStopcodeName = clinicStopcodeName;
	}


	public int getDaysElapsed() {
		return daysElapsed;
	}


	public void setDaysElapsed(int daysElapsed) {
		this.daysElapsed = daysElapsed;
	}


	public Date getDesiredAppointmentDate() {
		return desiredAppointmentDate;
	}


	public void setDesiredAppointmentDate(Date desiredAppointmentDate) {
		this.desiredAppointmentDate = desiredAppointmentDate;
	}


	public int getRecordResolvedInd() {
		return recordResolvedInd;
	}


	public void setRecordResolvedInd(int recordResolvedInd) {
		this.recordResolvedInd = recordResolvedInd;
	}


	public VAFacility getVaFacility() {
		return vaFacility;
	}


	public void setVaFacility(VAFacility vaFacility) {
		this.vaFacility = vaFacility;
	}


	public Date getWaitlistStartDate() {
		return waitlistStartDate;
	}


	public void setWaitlistStartDate(Date waitlistStartDate) {
		this.waitlistStartDate = waitlistStartDate;
	}


	public WaitType getWaitType() {
		return waitType;
	}


	public void setWaitType(WaitType waitType) {
		this.waitType = waitType;
	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("person", this.person);
		builder.append("clinicStopcode", this.clinicStopcode);
		builder.append("clinicStopcodeName", this.clinicStopcodeName);
		builder.append("daysElapsed", this.daysElapsed);
		builder.append("desiredAppointmentDate", this.desiredAppointmentDate);
		builder.append("recordResolvedInd", this.recordResolvedInd);
		builder.append("vaFacility", this.vaFacility);
		builder.append("waitlistStartDate", this.waitlistStartDate);
		builder.append("waitType", this.waitType);
    }

 }