/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.comms;

// Java Classes
import java.io.Serializable;

// Library Classes

// Framework Classes

// ESR Classes
import gov.va.med.esr.common.model.party.Address;

/**
 * This class contains information that is associated with a CommsLogEntry including a new
 * updated Address that can be used if one exists.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class UndeliverableMailInfo implements Serializable
{
    private static final long serialVersionUID = 3868971089008056381L;
    
    private CommsLogEntry commsLogEntry = null;
    private Address updatedAddress = null;

    public CommsLogEntry getCommsLogEntry()
    {
        return commsLogEntry;
    }

    public void setCommsLogEntry(CommsLogEntry commsLogEntry)
    {
        this.commsLogEntry = commsLogEntry;
    }

    public Address getUpdatedAddress()
    {
        return updatedAddress;
    }

    public void setUpdatedAddress(Address updatedAddress)
    {
        this.updatedAddress = updatedAddress;
    }
}