package gov.va.med.esr.common.model.comms;


import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.lookup.ComAACRejectReasonType;
import gov.va.med.esr.common.model.lookup.HandBookMailStatusType;
import gov.va.med.fw.model.AbstractKeyedEntity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class HandBookMailStatus extends  AbstractKeyedEntity {
	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -5790657963513810457L;
	
	private HandBookMailQueue handBookMailQueue;
	private BigDecimal handBookMailQueueId;
	private Date cmsFileGeneratedDate;
	private Date sentToUPSDate;
	private Date returnedFromUPSDate;
	private HandBookMailStatusType statusType;
	private BigDecimal statusTypeId;
	private String errorText = null;
	private ComAACRejectReasonType rejectReasonType = null;
	private BigDecimal rejectReasonTypeId;
	private BigDecimal hbmsId;  // original identifier - only used for HISTORY records

	private Set internalDocuments = new HashSet(); //HandBookDocument
	
	public Date getCmsFileGeneratedDate() {
		return cmsFileGeneratedDate;
	}
	public void setCmsFileGeneratedDate(Date cmsFileGeneratedDate) {
		this.cmsFileGeneratedDate = cmsFileGeneratedDate;
	}
	
	public Date getReturnedFromUPSDate() {
		return returnedFromUPSDate;
	}
	public void setReturnedFromUPSDate(Date returnedFromUPSDate) {
		this.returnedFromUPSDate = returnedFromUPSDate;
	}
	public Date getSentToUPSDate() {
		return sentToUPSDate;
	}
	public void setSentToUPSDate(Date sentToUPSDate) {
		this.sentToUPSDate = sentToUPSDate;
	}
	public HandBookMailStatusType getStatusType() {
		return statusType;
	}
	public void setStatusType(HandBookMailStatusType statusType) {
		this.statusType = statusType;
	}
	
    public String getErrorText() {
		return errorText;
	}
	public void setErrorText(String errorText) {
		this.errorText = errorText;
	}
	public void addErrText(String error){
		
		this.errorText += error;
	}
	public HandBookMailQueue getHandBookMailQueue() {
		return handBookMailQueue;
	}
	public void setHandBookMailQueue(HandBookMailQueue handBookMailQueue) {
		this.handBookMailQueue = handBookMailQueue;
	}
	public ComAACRejectReasonType getRejectReasonType() {
		return rejectReasonType;
	}
	public void setRejectReasonType(ComAACRejectReasonType rejectReasonType) {
		this.rejectReasonType = rejectReasonType;
	}
	public BigDecimal getHbmsId() {
		return hbmsId;
	}
	public void setHbmsId(BigDecimal hbmsId) {
		this.hbmsId = hbmsId;
	}
	public BigDecimal getStatusTypeId() {
		return statusTypeId;
	}
	public void setStatusTypeId(BigDecimal statusTypeId) {
		this.statusTypeId = statusTypeId;
	}
	public BigDecimal getRejectReasonTypeId() {
		return rejectReasonTypeId;
	}
	public void setRejectReasonTypeId(BigDecimal rejectReasonTypeId) {
		this.rejectReasonTypeId = rejectReasonTypeId;
	}
	public BigDecimal getHandBookMailQueueId() {
		return handBookMailQueueId;
	}
	public void setHandBookMailQueueId(BigDecimal handBookMailQueueId) {
		this.handBookMailQueueId = handBookMailQueueId;
	}
	
	
	/*
	 * for HandBookDocument
	 */
   private Set getInternalDocuments() {
      return this.internalDocuments;
   }

   private void setInternalDocuments(Set internalDocuments) {
		this.internalDocuments = internalDocuments;
	}

	public HandBookDocument getDocument() {
		Set docs = getInternalDocuments();
		if (docs.size() > 0) {
			return (HandBookDocument) docs.iterator().next();
		}
		return null;
	}

	public void setDocument(HandBookDocument document) {
		Set docs = getInternalDocuments();
		docs.clear();
		if (document != null) {
			docs.add(document);
			document.setMailStatus(this);
		}
	}

}
