package gov.va.med.esr.common.model.comms;

import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.HandBookMailStatusType;
import gov.va.med.esr.common.model.lookup.HandBookReleaseControl;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.fw.model.AbstractKeyedEntity;

import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;

public class HandBookMailQueue extends  AbstractKeyedEntity {
	
	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 3370639545976314371L;
		
	private BigDecimal templateId;
	private CommsTemplate template = null;
	private BigDecimal batchRequestId;
	private HandBookBatchRequest batchRequest;
	private BigDecimal personId;
	private BigDecimal hbmqId;  // original identifier - only used for HISTORY records
	private HandBookMailStatus handBookMailStatus;
	private BigDecimal mailStatusId;
	private String actionComment = null;
	private BigDecimal releaseControlId;
	private HandBookReleaseControl handBookReleaseControl = null;
	private BigDecimal mailQueueId;
	private BigDecimal addressId;
	private Address address;

	private static final String ACTION_COMMENT_SEPARATOR = System
	.getProperty("line.separator")
	+ System.getProperty("line.separator");

	public BigDecimal getAddressId() {
		return addressId;
	}
	public void setAddressId(BigDecimal addressId) {
		this.addressId = addressId;
	}
	
	public BigDecimal getMailQueueId() {
		return mailQueueId;
	}
	public void setMailQueueId(BigDecimal mailQueueId) {
		this.mailQueueId = mailQueueId;
	}
	
	 public BigDecimal getBatchRequestId() {
		return batchRequestId;
	}
	public void setBatchRequestId(BigDecimal batchRequestId) {
		this.batchRequestId = batchRequestId;
	}

	public BigDecimal getMailStatusId() {
		return mailStatusId;
	}
	public void setMailStatusId(BigDecimal mailStatusId) {
		this.mailStatusId = mailStatusId;
	}	
	
	
	public HandBookMailStatus getHandBookMailStatus() {
		return handBookMailStatus;
	}
	public void setHandBookMailStatus(HandBookMailStatus handBookMailStatus) {
		this.handBookMailStatus = handBookMailStatus;
	}
	
	public void setReleaseControlId(BigDecimal releaseControlId) {
		this.releaseControlId = releaseControlId;
	}	
	public BigDecimal getReleaseControlId() {
		return releaseControlId;
	}
	
	public void setHandBookReleaseControl(
			HandBookReleaseControl handBookReleaseControl) {
		this.handBookReleaseControl = handBookReleaseControl;
	}
	
	public HandBookReleaseControl getHandBookReleaseControl() {
		return handBookReleaseControl;
	}	
	
	
	public BigDecimal getPersonId() {
		return personId;
	}
	public void setPersonId(BigDecimal personId) {
		this.personId = personId;
	}
	public BigDecimal getTemplateId() {
		return templateId;
	}
	public void setTemplateId(BigDecimal templateId) {
		this.templateId = templateId;
	}	
	
	public CommsTemplate getTemplate() {
		return template;
	}
	public void setTemplate(CommsTemplate template) {
		this.template = template;
	}
	public HandBookBatchRequest getBatchRequest() {
		return batchRequest;
	}
	public void setBatchRequest(HandBookBatchRequest batchRequest) {
		this.batchRequest = batchRequest;
	}

	/**
	 * @return Returns the templateName.
	 */
	public String getTemplateName() {
		return (template == null) ? null : template.getCommsTemplateName();
	}

	/**
	 * @return Returns the version (i.e. the Release Control Number).
	 */
	public String getHandbookVersion() {
		return (handBookReleaseControl == null) ? null : handBookReleaseControl.getCode();
	}

	/**
	 * @return Returns the Id 
	 */
	public String getId() {
		return (this.getIdentifier().toString());
	}

	public boolean isSentToCMS () {
		return isTargetStatus (HandBookMailStatusType.SENT_TO_CMS);
	}

	public boolean isSendToCMS () {
		return isTargetStatus (HandBookMailStatusType.SEND_TO_CMS);
	}

	private boolean isTargetStatus(HandBookMailStatusType.Code targetStatus) {
		if (handBookMailStatus.getStatusType() == null) {
			return false;
		}
		return (handBookMailStatus.getStatusType().getCode().equals(targetStatus.getCode()));
	}

	
	public boolean isHandbook() {
		return isTargetDocument(ComLetterTemplateType.FORM_NUMBER_400H);
	}
	
	public boolean isHandbookAny() {
		return (isTargetDocument(ComLetterTemplateType.FORM_NUMBER_400H) || 
				isTargetDocument(ComLetterTemplateType.FORM_NUMBER_400B) || 
				isTargetDocument(ComLetterTemplateType.FORM_NUMBER_400F));
	}
	
	private boolean isTargetDocument(ComLetterTemplateType.Code targetDocument) {
    	String formNumber = (getFormNumber() == null) ? null : getFormNumber();
		return (targetDocument.getCode().equals(formNumber));
	}

	public String getFormNumber() {
		return (template == null) ? null : template
				.getCommsTemplateFormNumber();
	}

	
	
	// 3.6 CCR 10960
	// used on the Handbook Status page.  If the status is in (mailed by cms, returned by post office or rejected address by CMS) and the
	// document type is Handbook then the use can VIEW the document.
	public boolean isEligibleForView() {
		boolean isEligibleForView = false;
		if (isTargetStatus (HandBookMailStatusType.MAILED_BY_CMS) || 
				isTargetStatus (HandBookMailStatusType.RETURN_BY_POST_OFFICE) ||
				isTargetStatus (HandBookMailStatusType.REJECTED_ADDRESS_BY_CMS) ||
				isTargetStatus (HandBookMailStatusType.ONLINE	)) {
			isEligibleForView = isHandbookAny();
		}
		return isEligibleForView;
	}
	
	public String getActionComment() {
		return actionComment;
	}
	public void setActionComment(String actionComment) {
		this.actionComment = actionComment;
	}

	public BigDecimal getHbmqId() {
		return hbmqId;
	}
	public void setHbmqId(BigDecimal hbmqId) {
		this.hbmqId = hbmqId;
	}
	
	public void addActionComment(String actionComment) {
		if (StringUtils.isNotBlank(actionComment)) {
			if (StringUtils.isNotBlank(getActionComment())) {
				StringBuffer buf = new StringBuffer();
				buf.append(actionComment);
				buf.append(ACTION_COMMENT_SEPARATOR);
				buf.append(getActionComment());
				setActionComment(buf.toString());
			} else {
				setActionComment(actionComment);
			}
		}
	}

	public String getLatestActionComment() {
		String latestActionComment = getActionComment();
		if (StringUtils.isNotBlank(latestActionComment)
				&& latestActionComment.indexOf(ACTION_COMMENT_SEPARATOR) != -1)
			latestActionComment = latestActionComment
					.split(ACTION_COMMENT_SEPARATOR)[0];
		return latestActionComment;
	}
	
	public Address getAddress() {
		return address;
	}
	
	public void setAddress(Address address) {
		this.address = address;
	}
	
}
