
package gov.va.med.esr.common.model.comms;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.lang.Validate;

import gov.va.med.esr.common.model.lookup.HandBookMailStatusType;
import gov.va.med.esr.common.model.lookup.HandBookReleaseControl;
import gov.va.med.esr.common.model.lookup.HandBookRequestStatusType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;



/**
 * @author DNS   THOMAS
 *
 */
public class HandBookBatchRequest extends AbstractKeyedEntity {

	/**
	 * 
	 */
	private static final long serialVersionUID = 2982614992374560138L;

	private Date batchReleaseDate     =null;
	private Date batchCancelDate      =null;
	private String maxPerJobNumber;
	private String batchReleaseSize;
	private String  requestNote=null;
	private Set internalBatchRequestPriortyGroups = null;
	private Set internalBatchRequestFacilities = null;
	private HandBookRequestStatusType handBookRequestStatus=null;
	private HandBookReleaseControl handBookReleaseControl=null;
	
	private Set parentBatchRequestFacility =null;
	private  int numberOfRecordSendToCMS=0;
	private int numberOfRecordMailedByCMS=0;
	private int numberOfRecordOnline=0;
	



	/**
	 * Add a batchRequestFacility for this person. This method takes care of Bidirectional setting of
	 * batchRequestFacility's person.
	 * 
	 * @param batchRequestFacility
	 */
	public void addbatchRequestFacility(BatchRequestFacility batchRequestFacility) {
		Validate.notNull(batchRequestFacility, "Null batchRequestFacility specified.");
		getInternalBatchRequestFacilities().add(batchRequestFacility);
		batchRequestFacility.setHandBookBatchRequest(this);
	}

	/**
	 * Add a BatchRequestPriortyGroup for this HandBook Batch Request. This method takes care of Bidirectional setting of
	 * BatchRequestPriortyGroup's HandBook Batch Request.
	 * 
	 * @param BatchRequestPriortyGroup
	 */
	public void addBatchRequestPriortyGroup(BatchRequestPriortyGroup BatchRequestPriortyGroup) {
		Validate.notNull(BatchRequestPriortyGroup, "Null BatchRequestPriortyGroup specified.");
		getInternalBatchRequestPriortyGroups().add(BatchRequestPriortyGroup);
		BatchRequestPriortyGroup.setHandBookBatchRequest(this);
	}

	public Date getBatchCancelDate() {
		return batchCancelDate;
	}

	public Date getBatchReleaseDate() {
		return batchReleaseDate;
	}



	public String getBatchReleaseSize() {
		return batchReleaseSize;
	}

	/**
	 * Returns a collection of batchRequestFacility Objects. If no BatchRequestFacility exists for this person,
	 * this method will return empty Set.
	 * 
	 * @return Set - Set of batchRequestFacility, Never NULL
	 */
	public Set getBatchRequestFacility() {
		return Collections.unmodifiableSet(getInternalBatchRequestFacilities());
	}

	/**
	 * Returns a batchRequestFacility based on the entity key.
	 * 
	 * @param identifier
	 * @return batchRequestFacility
	 */
	public BatchRequestFacility getbatchRequestFacilityByEntityKey(EntityKey identifier) {
		return (BatchRequestFacility)getEntityByEntityKey(getBatchRequestFacility(), identifier);
	}

	public Set getBatchRequestPriortyGroup() {
		return Collections.unmodifiableSet(getInternalBatchRequestPriortyGroups());
	}


	/**
	 * Returns a BatchRequestPriortyGroups based on the entity key.
	 * 
	 * @param identifier
	 * @return batchRequestFacility
	 */
	public BatchRequestPriortyGroup getBatchRequestPriortyGroup(EntityKey identifier) {
		return (BatchRequestPriortyGroup)getEntityByEntityKey(getBatchRequestPriortyGroup(), identifier);
	}

	public HandBookReleaseControl getHandBookReleaseControl() {
		return handBookReleaseControl;
	}

	
	public HandBookRequestStatusType getHandBookRequestStatus() {
		return handBookRequestStatus;
	}

	private Set getInternalBatchRequestFacilities() {
		if( this.internalBatchRequestFacilities == null ) {
			this.internalBatchRequestFacilities = new HashSet();
		}
		return internalBatchRequestFacilities;
	}

	private Set getInternalBatchRequestPriortyGroups() {
		if( this.internalBatchRequestPriortyGroups == null ) {
			this.internalBatchRequestPriortyGroups = new HashSet();
		}
		return internalBatchRequestPriortyGroups;
	}

	public String getMaxPerJobNumber() {
		return maxPerJobNumber;
	}


	public int getNumberOfRecordMailedByCMS() {
		return numberOfRecordMailedByCMS;
	}

	public int getNumberOfRecordSendToCMS(){
		
		return numberOfRecordSendToCMS;
	}

	public int getNumberOfRecordOnline(){
		
		return numberOfRecordOnline;
	}

	public Set getParentBatchRequestFacility() {
		if( this.parentBatchRequestFacility == null ) {
			this.parentBatchRequestFacility = new HashSet();
		}
		Set parentFacility=this.getInternalBatchRequestFacilities();
		for (Iterator iter = parentFacility.iterator(); iter.hasNext();) {
			BatchRequestFacility facility = (BatchRequestFacility) iter.next();

			this.parentBatchRequestFacility.add(facility.getParentSite());
		}
		return parentBatchRequestFacility;
	}

	public String getRequestNote() {
		return requestNote;
	}

	/**
	 * Remove an batchRequestFacility from this person's batchRequestFacility collection. This method takes care of
	 * Bidirectional setting of batchRequestFacility's person.
	 * 
	 * @param batchRequestFacility
	 */
	public void removebatchRequestFacility(BatchRequestFacility batchRequestFacility) {
		Validate.notNull(batchRequestFacility, "Null batchRequestFacility specified.");
		getInternalBatchRequestFacilities().remove(batchRequestFacility);
	}


	/**
	 * Remove an BatchRequestPriortyGroup from this HandBook Batch Request's BatchRequestPriortyGroup collection. This method takes care of
	 * Bidirectional setting of BatchRequestPriortyGroup's HandBook Batch Request.
	 * 
	 * @param BatchRequestPriortyGroup
	 */
	public void removeBatchRequestPriortyGroup(BatchRequestPriortyGroup BatchRequestPriortyGroup) {
		Validate.notNull(BatchRequestPriortyGroup, "Null BatchRequestPriortyGroup specified.");
		getInternalBatchRequestPriortyGroups().remove(BatchRequestPriortyGroup);
	}

	public void setBatchCancelDate(Date batchCancelDate) {
		this.batchCancelDate = batchCancelDate;
	}
	public void setBatchReleaseDate(Date batchReleaseDate) {
		this.batchReleaseDate = batchReleaseDate;
	}

	public void setBatchReleaseSize(String batchReleaseSize) {
		this.batchReleaseSize = batchReleaseSize;
	}

	public void setHandBookReleaseControl(
			HandBookReleaseControl handBookReleaseControl) {
		this.handBookReleaseControl = handBookReleaseControl;
	}

	public void setHandBookRequestStatus(HandBookRequestStatusType handBookRequestStatus) {
		this.handBookRequestStatus = handBookRequestStatus;
	}

	private void setInternalBatchRequestFacilities(Set internalBatchRequestFacilities) {
		this.internalBatchRequestFacilities = internalBatchRequestFacilities;
	}


	
	private void setInternalBatchRequestPriortyGroups(
			Set internalBatchRequestPriortyGroups) {
		this.internalBatchRequestPriortyGroups = internalBatchRequestPriortyGroups;
	}
	public void setMaxPerJobNumber(String maxPerJobNumber) {
		this.maxPerJobNumber = maxPerJobNumber;
	}


	public void setNumberOfRecordMailedByCMS(int numberOfRecordMailedByCMS) {
		this.numberOfRecordMailedByCMS = numberOfRecordMailedByCMS;
	}

	public void setNumberOfRecordSendToCMS(int numberOfRecordSendToCMS) {
		this.numberOfRecordSendToCMS = numberOfRecordSendToCMS;
	}

	public void setNumberOfRecordOnline(int numberOfRecordOnline) {
		this.numberOfRecordOnline = numberOfRecordOnline;
	}

	public void setRequestNote(String requestNote) {
		this.requestNote = requestNote;
	}
}
