/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.comms;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
// Java classes
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.party.HistoricAddress;
import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * Address BOM
 * @author DNS   MANSOG
 * @version 1.0
 */
public class GeocodeTransmit extends AbstractKeyedEntity {
	


	/**
	 * 
	 */
	private static final long serialVersionUID = -7632030639345897908L;

	private Person person;

	// CR 13726 insisted on fetching from ADDRESS_H table, not ADDRESS
	private HistoricAddress historicAddress;
	private int addressExactMatchInd;
	private int addressLatitude;
	private String addressLocationName;
	private int addressLongitude;
	private String addressMatchType;

	private String addressLine1;
	private String addressLine2;
	private String city;
	private String state;
	private String zip;
	private String zipPlus4;
	private String congressionalDistrict;
	private String country;
	private String countyName;
	private String district;
	private String districtName;
	private int drivingDistance;
	private String fips;
	private Date geocodeDate;
	private Integer geocodeStationId;
	private String geocodeSwVer;
	private String geocodingFlag;
	private String market;
	private String marketName;
	private String matchAddress;
	private String newVisn;

	private String sector;
	private String stateByCounty;
	private String stateFips;
	private String submarket;
	private String urhCode;


	public Person getPerson() {
		return person;
	}

	public void setPerson(Person person) {
		this.person = person;
	}


	public HistoricAddress getHistoricAddress() {
		return historicAddress;
	}

	public void setHistoricAddress(HistoricAddress historicAddress) {
		this.historicAddress = historicAddress;
	}

	public int getAddressExactMatchInd() {
		return addressExactMatchInd;
	}

	public void setAddressExactMatchInd(int addressExactMatchInd) {
		this.addressExactMatchInd = addressExactMatchInd;
	}

	public int getAddressLatitude() {
		return addressLatitude;
	}

	public void setAddressLatitude(int addressLatitude) {
		this.addressLatitude = addressLatitude;
	}

	public String getAddressLocationName() {
		return addressLocationName;
	}

	public void setAddressLocationName(String addressLocationName) {
		this.addressLocationName = addressLocationName;
	}

	public int getAddressLongitude() {
		return addressLongitude;
	}

	public void setAddressLongitude(int addressLongitude) {
		this.addressLongitude = addressLongitude;
	}

	public String getAddressMatchType() {
		return addressMatchType;
	}

	public void setAddressMatchType(String addressMatchType) {
		this.addressMatchType = addressMatchType;
	}

	public String getAddressLine1() {
		return addressLine1;
	}

	public void setAddressLine1(String addressLine1) {
		this.addressLine1 = addressLine1;
	}

	public String getAddressLine2() {
		return addressLine2;
	}

	public void setAddressLine2(String addressLine2) {
		this.addressLine2 = addressLine2;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getZip() {
		return zip;
	}

	public void setZip(String zip) {
		this.zip = zip;
	}

	public String getZipPlus4() {
		return zipPlus4;
	}

	public void setZipPlus4(String zipPlus4) {
		this.zipPlus4 = zipPlus4;
	}

	public String getCongressionalDistrict() {
		return congressionalDistrict;
	}

	public void setCongressionalDistrict(String congressionalDistrict) {
		this.congressionalDistrict = congressionalDistrict;
	}

	public String getCountry() {
		return country;
	}

	public void setCountry(String country) {
		this.country = country;
	}

	public String getCountyName() {
		return countyName;
	}

	public void setCountyName(String countyName) {
		this.countyName = countyName;
	}

	public String getDistrict() {
		return district;
	}

	public void setDistrict(String district) {
		this.district = district;
	}

	public String getDistrictName() {
		return districtName;
	}

	public void setDistrictName(String districtName) {
		this.districtName = districtName;
	}

	public int getDrivingDistance() {
		return drivingDistance;
	}

	public void setDrivingDistance(int drivingDistance) {
		this.drivingDistance = drivingDistance;
	}

	public String getFips() {
		return fips;
	}

	public void setFips(String fips) {
		this.fips = fips;
	}

	public String getGeocodeDateStr() {
		DateFormat df = new SimpleDateFormat("MM/dd/yyyy");
		String dateStr;
		try {
			dateStr = df.format(geocodeDate);
		} catch (Exception ex ) {
			dateStr = "";
		}
		return dateStr;
	}

	public Date getGeocodeDate() {
		return geocodeDate;
	}

	public void setGeocodeDate(Date geocodeDate) {
		this.geocodeDate = geocodeDate;
	}

	public Integer getGeocodeStationId() {
		return geocodeStationId;
	}

	public void setGeocodeStationId(Integer geocodeStationId) {
		this.geocodeStationId = geocodeStationId;
	}

	public String getGeocodeSwVer() {
		return geocodeSwVer;
	}

	public void setGeocodeSwVer(String geocodeSwVer) {
		this.geocodeSwVer = geocodeSwVer;
	}

	public String getGeocodingFlag() {
		return geocodingFlag;
	}

	public void setGeocodingFlag(String geocodingFlag) {
		this.geocodingFlag = geocodingFlag;
	}

	public String getMarket() {
		return market;
	}

	public void setMarket(String market) {
		this.market = market;
	}

	public String getMarketName() {
		return marketName;
	}

	public void setMarketName(String marketName) {
		this.marketName = marketName;
	}

	public String getMatchAddress() {
		return matchAddress;
	}

	public void setMatchAddress(String matchAddress) {
		this.matchAddress = matchAddress;
	}

	public String getNewVisn() {
		return newVisn;
	}

	public void setNewVisn(String newVisn) {
		this.newVisn = newVisn;
	}

	public String getSector() {
		return sector;
	}

	public void setSector(String sector) {
		this.sector = sector;
	}

	public String getStateByCounty() {
		return stateByCounty;
	}

	public void setStateByCounty(String stateByCounty) {
		this.stateByCounty = stateByCounty;
	}

	public String getStateFips() {
		return stateFips;
	}

	public void setStateFips(String stateFips) {
		this.stateFips = stateFips;
	}

	public String getSubmarket() {
		return submarket;
	}

	public void setSubmarket(String submarket) {
		this.submarket = submarket;
	}

	public String getUrhCode() {
		return urhCode;
	}

	public void setUrhCode(String urhCode) {
		this.urhCode = urhCode;
	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("person", "person");
		builder.append("address", "address");

		builder.append("addressExactMatchInd", "addressExactMatchInd");
		builder.append("addressLatitude", "addressLatitude");
		builder.append("addressLocationName", "addressLocationName");
		builder.append("addressLongitude", "addressLongitude");
		builder.append("addressMatchType", "addressMatchType");

		builder.append("addressLine1", "addressLine1");
		builder.append("addressLine2", "addressLine2");
		builder.append("city", "city");
		builder.append("state", "state");
		builder.append("zip", "zip");
		builder.append("zipPlus4", "zipPlus4");
		builder.append("congressionalDistrict", "congressionalDistrict");
		builder.append("country", "country");
		builder.append("countyName", "countyName");
		builder.append("district", "district");
		builder.append("districtName", "districtName");
		builder.append("drivingDistance", "drivingDistance");
		builder.append("fips", "fips");
		builder.append("geocodeDate", "geocodeDate");
		builder.append("geocodeStationId", "geocodeStationId");
		builder.append("geocodeSwVer", "geocodeSwVer");
		builder.append("geocodingFlag", "geocodingFlag");
		builder.append("market", "market");
		builder.append("marketName", "marketName");
		builder.append("matchAddress", "matchAddress");
		builder.append("newVisn", "newVisn");

		builder.append("sector", "sector");
		builder.append("stateByCounty", "stateByCounty");
		builder.append("stateFips", "stateFips");
		builder.append("submarket", "submarket");
		builder.append("urhCode", "urhCode");
    }

 }