package gov.va.med.esr.common.model.comms;

import gov.va.med.esr.common.model.lookup.VeteranIdentifierType;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.AbstractVersionedEntity;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.collections.set.UnmodifiableSet;

public class DocumentReceipt extends AbstractKeyedEntity {
	
	private static final long serialVersionUID = -6712396040378523357L;	
	
	private Date receiptDate = null;
	
	private int versionNumber;
	
	private String VPIDValue = null;
	
	private String receiptString = null;
	
	private String releaseControlNumber = null;
	
	private VeteranIdentifierType veteranIdentifierType = null;
	
	private Set internalDocuments = null;
	
	private Set internalHealthBenefitPlan = null;
	

	public Date getReceiptDate() {
		return receiptDate;
	}

	public void setReceiptDate(Date receiptDate) {
		this.receiptDate = receiptDate;
	}

	public String getReceiptString() {
		return receiptString;
	}

	public void setReceiptString(String receiptString) {
		this.receiptString = receiptString;
	}

	public String getReleaseControlNumber() {
		return releaseControlNumber;
	}

	public void setReleaseControlNumber(String releaseControlNumber) {
		this.releaseControlNumber = releaseControlNumber;
	}

	public int getVersionNumber() {
		return versionNumber;
	}

	public void setVersionNumber(int versionNumber) {
		this.versionNumber = versionNumber;
	}

	public String getVPIDValue() {
		return VPIDValue;
	}

	public void setVPIDValue(String value) {
		VPIDValue = value;
	}
	
	public VeteranIdentifierType getVeteranIdentifierType() {
		return this.veteranIdentifierType;
	}

	public void setVeteranIdentifierType(VeteranIdentifierType veteranIdentifierType) {
		this.veteranIdentifierType = veteranIdentifierType;
	}

	private Set getInternalDocuments() {
		if (this.internalDocuments == null) {
			this.internalDocuments = new HashSet();
		}
		return this.internalDocuments;
	}

	private void setInternalDocuments(Set documents) {
		this.internalDocuments = documents;
	}
	
	public Set getDocuments() {
		return UnmodifiableSet.decorate(getInternalDocuments());
	}
	
	public void addDocument(Document document) {
		if (this.internalDocuments == null) {
			this.internalDocuments = new HashSet();
		}
		internalDocuments.add(document);
		document.setDocumentReceipt(this);
	}
	
	public Set getInternalHealthBenefitPlan() {
		if (this.internalHealthBenefitPlan == null) {
			this.internalHealthBenefitPlan = new HashSet();
		}
		return this.internalHealthBenefitPlan;		
	}

	private void setInternalHealthBenefitPlan(Set healthBenefitPlans) {
		this.internalHealthBenefitPlan = healthBenefitPlans;
	}
	
	public void addHealthBenefitPlan(HealthBenefitPlan healthBenefitPlan) {
		if (this.internalHealthBenefitPlan == null) {
			this.internalHealthBenefitPlan = new HashSet();
		}
		
		//Check if this Plan already Exists. if yes then ignore silently
		Iterator planItr = internalHealthBenefitPlan.iterator();
		boolean foundDup = false;
		while ( planItr.hasNext() ) {
			HealthBenefitPlan currPlan = (HealthBenefitPlan) planItr.next();
			String coveragePlanCode = currPlan.getCoveragePlanCode();
			String healthBenefitCode = currPlan.getHealthBenefitCode();
			String healthBenefitCategory = currPlan.getHealthBenefitCategory();
			
			if (coveragePlanCode != null && coveragePlanCode.equals(healthBenefitPlan.getCoveragePlanCode()) &&  
				healthBenefitCode != null && healthBenefitCode.equals(healthBenefitPlan.getHealthBenefitCode()) && 
				healthBenefitCategory != null && healthBenefitCategory.equals(healthBenefitPlan.getHealthBenefitCategory()) ) {
				foundDup = true;
			}
			
		}
		if ( ! foundDup ) {
			this.internalHealthBenefitPlan.add(healthBenefitPlan);
			healthBenefitPlan.setDocumentReceipt(this);
		}
	}
	
	public Set getPlans() {
		return UnmodifiableSet.decorate(getInternalHealthBenefitPlan());
	}



}
