package gov.va.med.esr.common.model.comms;

import java.util.Date;
import gov.va.med.esr.common.model.lookup.DocumentType;
import gov.va.med.fw.model.AbstractKeyedEntity;

public class Document extends AbstractKeyedEntity{
	
	private static final long serialVersionUID = -6712396040378523357L;
	
	private Date creationDate = null;
	
	private String receiptString = null;
	
	private FileInfo fileInfo = null;
	
	private DocumentType documentType = null;
	
	private DocumentReceipt documentReceipt = null;

	public DocumentReceipt getDocumentReceipt() {
		return documentReceipt;
	}

	public void setDocumentReceipt(DocumentReceipt documentReceipt) {
	   validateOwner(this.documentReceipt, documentReceipt);
	   this.documentReceipt = documentReceipt;
	}

	public DocumentType getDocumentType() {
		return documentType;
	}

	public void setDocumentType(DocumentType documentType) {
		this.documentType = documentType;
	}

	public FileInfo getFileInfo() {
		return fileInfo;
	}

	public void setFileInfo(FileInfo fileInfo) {
		this.fileInfo = fileInfo;
	}

	public Date getCreationDate() {
		return creationDate;
	}

	public void setCreationDate(Date creationDate) {
		this.creationDate = creationDate;
	}

	public String getReceiptString() {
		return receiptString;
	}

	public void setReceiptString(String receiptString) {
		this.receiptString = receiptString;
	}
	

}
