/**
 * 
 */
package gov.va.med.esr.common.model.comms;

import gov.va.med.esr.common.model.lookup.DeliveryPreferenceSourceOfChange;
import gov.va.med.esr.common.model.lookup.DeliveryPreferenceType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.model.AbstractKeyedEntity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/**
 * @author DNS   CHINNR
 * 
 */
public class DeliveryPreference extends AbstractKeyedEntity {

	/**
	 * Auto generated serialization number. 
	 */
	private static final long serialVersionUID = -8195927047035370987L;
	
	/**
	 * Could be Mail or Online
	 */
	private DeliveryPreferenceType deliveryPreferenceType = null;
	
	/**
	 * Source that change the Delivery Preference, could be HEC or Veteran Self Service (VSS) 
	 */
	private DeliveryPreferenceSourceOfChange sourceOfChange;
	
	/**
	 * Change date
	 */
	private Date changeDate;
	
	/**
	 * Veteran Identifier
	 */
	private BigDecimal personId;
	
	private Person person = null;
	
	/**
	 * Delivery preference emails
	 */
	private Set<DeliveryPreferenceEmail> deliveryPreferenceEmail = new HashSet<DeliveryPreferenceEmail>();

	public Date getChangeDate() {
		return changeDate;
	}

	public void setChangeDate(Date changeDate) {
		this.changeDate = changeDate;
	}

	public DeliveryPreferenceSourceOfChange getSourceOfChange() {
		return sourceOfChange;
	}

	public void setSourceOfChange(
			DeliveryPreferenceSourceOfChange sourceOfChange) {
		this.sourceOfChange = sourceOfChange;
	}

	public BigDecimal getPersonId() {
		return personId;
	}

	public void setPersonId(BigDecimal personId) {
		this.personId = personId;
	}

	public Set<DeliveryPreferenceEmail> getDeliveryPreferenceEmail() {
		return deliveryPreferenceEmail;
	}

	public void setDeliveryPreferenceEmail(
			Set<DeliveryPreferenceEmail> deliveryPreferenceEmail) {
		this.deliveryPreferenceEmail = deliveryPreferenceEmail;
	}
	/**
	 * Although the mapping allows multiple emails, the business requirement only allows one email.
	 * This is a convenient method to get a single email in the Set. 
	 * @param email
	 */
	public DeliveryPreferenceEmail getEmail()
	{
		if (getDeliveryPreferenceEmail() == null || getDeliveryPreferenceEmail().size()== 0)
			return null;
		
		return (DeliveryPreferenceEmail)getDeliveryPreferenceEmail().iterator().next();
	}
	
	/**
	 * Although the mapping allows multiple emails, the business requirement only allows one email.
	 * This is a convenient method to set a single email in the Set. 
	 * NOTE: If a null email is passed in, it will remove all emails in the mapping
	 * @param email
	 */
	public void setEmail(DeliveryPreferenceEmail email)
	{
		if (email == null)
		{
			deliveryPreferenceEmail.clear(); //wipe out email
			return;
		}
		
		if (getDeliveryPreferenceEmail().size()== 0)
		{
			//add new email
			email.setDeliveryPreference(this);
			deliveryPreferenceEmail.add(email);
			
		} else
		{
			//update existing email
			DeliveryPreferenceEmail onFile = this.getEmail();
			onFile.setAddress(email.getAddress());
			onFile.setType(email.getType());
		}
	}

	public void setDeliveryPreferenceType(
			DeliveryPreferenceType deliveryPreferenceType) {
		this.deliveryPreferenceType = deliveryPreferenceType;
	}

	public DeliveryPreferenceType getDeliveryPreferenceType() {
		return deliveryPreferenceType;
	}

	public Person getPerson() {
		return person;
	}

	public void setPerson(Person person) {
		this.person = person;
	}
}
