package gov.va.med.esr.common.model.comms;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

import gov.va.med.esr.common.model.lookup.CorrespondenceStatus;
import gov.va.med.esr.common.model.lookup.CorrespondenceType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Email;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.model.AbstractKeyedEntity;

public class Correspondence extends AbstractKeyedEntity{

	private static final long serialVersionUID = -6712396010370023357L;

	private CorrespondenceType correspondenceType = null;
	private CorrespondenceStatus correspondenceStatus = null;
	private BigDecimal personId;
	private Date statusDate = null;
	private Date effectiveDate = null;
	private CorrespondenceDocument correspondenceDocument = null;
	private CommsTemplate letterTemplate = null;
	private CommsBulletin emailTemplate = null;
	private Email emailAddress = null;
	private BigDecimal addressId = null;
	private BigDecimal correspondenceId = null;
	private String errorDescription = null;
	private Address mailingAddress = null;
	private String correctionInd = null;
	private String taxYear = null;
	private String statusName = null;
	private String formName = null;
	private String mailingAddressText = null;
	private ArrayList<Correspondence> statusHistory = null;


	public CorrespondenceType getCorrespondenceType() {
		return correspondenceType;
	}


	public void setCorrespondenceType(CorrespondenceType correspondenceType) {
		this.correspondenceType = correspondenceType;
	}


	public CorrespondenceStatus getCorrespondenceStatus() {
		return correspondenceStatus;
	}


	public void setCorrespondenceStatus(CorrespondenceStatus correspondenceStatus) {
		this.correspondenceStatus = correspondenceStatus;
	}


	public BigDecimal getPersonId() {
		return personId;
	}


	public void setPersonId(BigDecimal personId) {
		this.personId = personId;
	}


	public Date getStatusDate() {
		return statusDate;
	}


	public void setStatusDate(Date statusDate) {
		this.statusDate = statusDate;
	}


	public Date getEffectiveDate() {
		return effectiveDate;
	}


	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}


	public CorrespondenceDocument getCorrespondenceDocument() {
		return correspondenceDocument;
	}


	public void setCorrespondenceDocument(
			CorrespondenceDocument correspondenceDocument) {
		this.correspondenceDocument = correspondenceDocument;
	}


	public CommsTemplate getLetterTemplate() {
		return letterTemplate;
	}


	public void setLetterTemplate(CommsTemplate letterTemplate) {
		this.letterTemplate = letterTemplate;
	}


	public CommsBulletin getEmailTemplate() {
		return emailTemplate;
	}


	public void setEmailTemplate(CommsBulletin emailTemplate) {
		this.emailTemplate = emailTemplate;
	}


	public Email getEmailAddress() {
		return emailAddress;
	}


	public void setEmailAddress(Email emailAddress) {
		this.emailAddress = emailAddress;
	}


	public String getErrorDescription() {
		return errorDescription;
	}


	public void setErrorDescription(String errorDescription) {
		this.errorDescription = errorDescription;
	}


	/**
	  * Default constructor.
	  */
	public Correspondence() {
		super();
	}

	public Correspondence(Person p) {
		super();
		this.setPersonId(new BigDecimal(p.getPersonEntityKey().getKeyValueAsString()));
	}


	public BigDecimal getAddressId() {
		return addressId;
	}


	public void setAddressId(BigDecimal addressId) {
		this.addressId = addressId;
	}


	public Address getMailingAddress() {
		return mailingAddress;
	}


	public void setMailingAdress(Address mailingAddress) {
		this.mailingAddress = mailingAddress;
	}


	public String getCorrectionInd() {
		Calendar cal = Calendar.getInstance();
		cal.setTime(this.getEffectiveDate());

		if (cal.get(Calendar.DAY_OF_YEAR) > 1) {
			return "Correction";
		} else {
			return "Original";
		}

	}


	public void setCorrectionInd(String correctionInd) {
		this.correctionInd = correctionInd;
	}


	public String getTaxYear() {
		Calendar cal = Calendar.getInstance();
		cal.setTime(this.getEffectiveDate());

		return (String.valueOf(cal.get(Calendar.YEAR)));

	}


	public void setTaxYear(String taxYear) {
		this.taxYear = taxYear;
	}


	public String getStatusName() {
		return this.getCorrespondenceStatus().getName();
	}


	public void setStatusName(String statusName) {
		this.statusName = statusName;
	}


	public String getFormName() {

		if (this.letterTemplate.getCommsTemplateFormNumber().equals("742-800A")) {
			return "742-800A - ACA Letter";

		} else if (this.letterTemplate.getCommsTemplateFormNumber().equals("742-800D")) {
			return "742-800D - ACA Letter (Deceased)";
		}

		return this.letterTemplate.getCommsTemplateName();
	}


	public void setFormName(String formName) {
		this.formName = formName;
	}


	public String getMailingAddressText() {

		String addressTxt = "";
		if (this.mailingAddress != null) {
			addressTxt += mailingAddress.getFormattedAddress();
		} else {
			addressTxt = "Not Assigned [Mailing Request Not Sent By ES or Sent Manually]";
		}

		return addressTxt;
	}


	public void setMailingAddressText(String mailingAddressText) {
		this.mailingAddressText = mailingAddressText;
	}


	public ArrayList<Correspondence> getStatusHistory() {
		return statusHistory;
	}


	public void setStatusHistory(ArrayList<Correspondence> statusHistory) {
		this.statusHistory = statusHistory;
	}


	public BigDecimal getCorrespondenceId() {
		return correspondenceId;
	}


	public void setCorrespondenceId(BigDecimal correspondenceId) {
		this.correspondenceId = correspondenceId;
	}



}
