package gov.va.med.esr.common.model.comms;

import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.fw.model.AbstractKeyedEntity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;


/** 
 *        @hibernate.class
 *         table="COMMS_TRANS_LOG"
 *     
*/
public class CommsTransLog extends AbstractKeyedEntity  {

    private static final long serialVersionUID = 7562783520526796167L;

    /** nullable persistent field */
    private String fileName;

    /** nullable persistent field */
    private Integer fileRecordCount;

    private Date fileReceivedDate = null;
    
    private Date fileProcessStartDate = null;
    
    private Date fileProcessEndDate = null;
    
    /** nullable persistent field */
    private MessageType transmissionType;
    
    private List commsTransByFormNumberList = new ArrayList();

   
    /** default constructor */
    public CommsTransLog() {
    }


    /** 
     *            @hibernate.property
     *             column="COMMS_TRANS_LOG_FILE_NAME"
     *             length="45"
     *         
     */
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /** 
     *            @hibernate.property
     *             column="COMMS_TRANS_LOG_RECORD_COUNT"
     *             length="8"
     *         
     */
    public Integer getFileRecordCount() {
        return this.fileRecordCount;
    }

    public void setFileRecordCount(Integer fileRecordCount) {
        this.fileRecordCount = fileRecordCount;
    }


    /** 
     *            @hibernate.property
     *             column="TRANS_TYPE_CODE"
     *             length="8"
     *         
     */
    public MessageType getTransmissionType() {
        return this.transmissionType;
    }

    public void setTransmissionType(MessageType transmissionType) {
        this.transmissionType = transmissionType;
    }

    /**
     * @return Returns the fileProcessEndDate.
     */
    public Date getFileProcessEndDate() {
        return fileProcessEndDate;
    }
    /**
     * @param fileProcessEndDate The fileProcessEndDate to set.
     */
    public void setFileProcessEndDate(Date fileProcessEndDate) {
        this.fileProcessEndDate = fileProcessEndDate;
    }
    /**
     * @return Returns the fileProcessStartDate.
     */
    public Date getFileProcessStartDate() {
        return fileProcessStartDate;
    }
    /**
     * @param fileProcessStartDate The fileProcessStartDate to set.
     */
    public void setFileProcessStartDate(Date fileProcessStartDate) {
        this.fileProcessStartDate = fileProcessStartDate;
    }
    /**
     * @return Returns the fileReceivedDate.
     */
    public Date getFileReceivedDate() {
        return fileReceivedDate;
    }
    /**
     * @param fileReceivedDate The fileReceivedDate to set.
     */
    public void setFileReceivedDate(Date fileReceivedDate) {
        this.fileReceivedDate = fileReceivedDate;
    }

    /**
     * @return Returns the commsTransByFormNumberList.
     */
    public List getCommsTransByFormNumberList() {
        return commsTransByFormNumberList;
    }
    /**
     * @param commsTransByFormNumberList The commsTransByFormNumberList to set.
     */
    public void setCommsTransByFormNumberList(List commsTransByFormNumberList) {
        this.commsTransByFormNumberList = commsTransByFormNumberList;
    }
    
    public void addTransByFormNumber(CommsTransByFormNumber transByFormNumber)
    {
        if (transByFormNumber != null)
        	transByFormNumber.setTransLog(this);
            commsTransByFormNumberList.add(transByFormNumber);
    }
    
    public String toString() {
        return new ToStringBuilder(this)
            .append("commsTransLogIdentifier", getIdentifier())
            .toString();
    }

}
