/********************************************************************
 * Copyright  2005-2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.comms;

// Java Classes
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

// Library Classes
import org.apache.commons.lang.builder.ToStringBuilder;

// Framework Classes
import gov.va.med.fw.service.pagination.SearchQueryInfo;

// ESR Classes
import gov.va.med.esr.common.model.lookup.State;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;

/**
 * This class extends the default SearchQueryInfo by adding the search
 * parameters needed to perform a CommsLogEntry search.
 * 
 * @author Andrew Pach
 * @version 3.0
 */
public class CommsLogSearchQueryInfo extends SearchQueryInfo implements
		Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static final String MASSKED_SSN = "***-**-****";
	
	private String SSN = null;

	private String barcode = null;

	private String givenName = null;

	private String middleName = null;

	private String familyName = null;

	private String addressLine1;

	private String addressLine2;

	private String addressLine3;

	private String city;

	private String county;

	private State state;

	private String zipCode;

	private String zipPlus4;

	private String country;

	private String province;

	private String postalCode;

	private ComLetterTemplateType formNumber = null;

	private BigDecimal caseNumber = null;

	private Date dateMailed = null;

	public String getSSN() {
		return SSN;
	}

	public void setSSN(String SSN) {
		this.SSN = SSN;
	}

	public String getGivenName() {
		return givenName;
	}

	public void setGivenName(String givenName) {
		this.givenName = givenName;
	}

	public String getMiddleName() {
		return middleName;
	}

	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	public String getFamilyName() {
		return familyName;
	}

	public void setFamilyName(String familyName) {
		this.familyName = familyName;
	}

	public String getAddressLine1() {
		return addressLine1;
	}

	public void setAddressLine1(String addressLine1) {
		this.addressLine1 = addressLine1;
	}

	public String getAddressLine2() {
		return addressLine2;
	}

	public void setAddressLine2(String addressLine2) {
		this.addressLine2 = addressLine2;
	}

	public String getAddressLine3() {
		return addressLine3;
	}

	public void setAddressLine3(String addressLine3) {
		this.addressLine3 = addressLine3;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getCounty() {
		return county;
	}

	public void setCounty(String county) {
		this.county = county;
	}

	public State getState() {
		return state;
	}

	public void setState(State state) {
		this.state = state;
	}

	public String getZipCode() {
		return zipCode;
	}

	public void setZipCode(String zipCode) {
		this.zipCode = zipCode;
	}

	public String getZipPlus4() {
		return zipPlus4;
	}

	public void setZipPlus4(String zipPlus4) {
		this.zipPlus4 = zipPlus4;
	}

	public String getCountry() {
		return country;
	}

	public void setCountry(String country) {
		this.country = country;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getPostalCode() {
		return postalCode;
	}

	public void setPostalCode(String postalCode) {
		this.postalCode = postalCode;
	}

	public ComLetterTemplateType getFormNumber() {
		return formNumber;
	}

	public void setFormNumber(ComLetterTemplateType formNumber) {
		this.formNumber = formNumber;
	}

	public BigDecimal getCaseNumber() {
		return caseNumber;
	}

	public void setCaseNumber(BigDecimal caseNumber) {
		this.caseNumber = caseNumber;
	}

	public Date getDateMailed() {
		return dateMailed;
	}

	public void setDateMailed(Date dateMailed) {
		this.dateMailed = dateMailed;
	}

	public String getBarcode() {
		return barcode;
	}

	public void setBarcode(String barcode) {
		this.barcode = barcode;
	}

	/**
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("SSN", MASSKED_SSN); //getSSN());
		builder.append("barcode", getBarcode());
		builder.append("givenName", getGivenName());
		builder.append("middleName", getMiddleName());
		builder.append("familyName", getFamilyName());
		builder.append("addressLine1", getAddressLine1());
		builder.append("addressLine2", getAddressLine2());
		builder.append("addressLine3", getAddressLine3());
		builder.append("city", getCity());
		builder.append("county", getCounty());
		builder.append("state", getState() != null ? getState().getFipsCode()
				: null);
		builder.append("zipCode", getZipCode());
		builder.append("zipPlus4", getZipPlus4());
		builder.append("country", getCountry());
		builder.append("province", getProvince());
		builder.append("postalCode", getPostalCode());
		builder.append("formNumber", getFormNumber() != null ? getFormNumber()
				.getDescription() : null);
		builder.append("caseNumber", getCaseNumber());
		builder.append("dateMailed", getDateMailed());
	}
}