/*
 * Created on Mar 2, 2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.common.model.comms;

//Java
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

//Common
import gov.va.med.esr.common.model.comms.ErrorFileEntry;
import gov.va.med.esr.common.model.comms.RejectFileEntry;
import gov.va.med.esr.common.model.comms.MailedFileEntry;

/**
 * @author DNS   TSAIG
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class CommsImportStatistics {

    //error file attributes
    private String errorFileName;
    private Date errorFileReceivedDate;
    private int errorFileRecordCount = 0;
    private Hashtable errorPerTypeNumberTable = new Hashtable();
    private Hashtable errorReasonPerLetterTypeTable = new Hashtable();
    private Date errorFileProcessStartTime = null;
    private Date errorFileProcessEndTime = null;
    private int errorFileProcessedCount;
    private int errorFileFailedCount;
    
    //reject file attributes
    private String rejectFileName;
    private Date rejectFileReceivedDate;
    private int rejectFileRecordCount = 0;
    private Hashtable rejectPerTypeNumberTable = new Hashtable();
    private Hashtable rejectReasonPerLetterTypeTable = new Hashtable();
    private Date rejectFileProcessStartTime = null;
    private Date rejectFileProcessEndTime = null;;
    private int rejectFileProcessedCount;
    private int rejectFileFailedCount;
    
    //mailed file attributes
    private String mailedFileName;
    private Date mailedFileReceivedDate;
    private int mailedFileRecordCount = 0;
    private Hashtable mailedPerTypeNumberTable = new Hashtable();
    private Date mailedFileProcessStartTime = null;
    private Date mailedFileProcessEndTime = null;
    private int mailedFileProcessedCount;
    private int mailedFileFailedCount;
    
    // Returned Mail attributes
    private int returnedMailFileProcessedCount = 0;
    
    private Date processStartTime = null;
    private Date processEndTime = null;
    
    
	//    5259[UC17.5.3]  
	//    The system captures and stores the following statistics that will be used to generate a report:
	//    Date/Time File Received
	//    File Name
	//    Number of Error Records Per File
	//    Break out the letters by type and how many per type
	//    For each letter type, the error reason(s)  
    public void updateErrorStatistics(ErrorFileEntry entry, boolean isNewLogEntry)
    {
        errorFileRecordCount++;
        
        String formNumber = (String)entry.getFormNumber();
        
        if (formNumber != null)
        {
            //letter type and number per type
            Integer cnt = (Integer)errorPerTypeNumberTable.get(formNumber);
            if (cnt == null) //new form is found, initialize with count 1
                errorPerTypeNumberTable.put(formNumber, new Integer(1));
            else //existing form
                if (isNewLogEntry) //since one letter can have multiple error entries, only increment count by 1 if it's a new log entry
                    errorPerTypeNumberTable.put(formNumber, new Integer(cnt.intValue()+1));
        
            String errorCode = entry.getErrorCode();
            
            if (errorCode != null)
            {
                //for each letter type (form number), the error reasons
                Set errorReasons = (Set) errorReasonPerLetterTypeTable.get(formNumber);

                if (errorReasons == null)
                {
                    //new form is found, initialize with a new set
                    Set newCode = new HashSet();
                    newCode.add(errorCode);
                    errorReasonPerLetterTypeTable.put(formNumber, newCode);
                }
                else
                    errorReasons.add(entry.getErrorCode());
            }
        }   
    }
    public void updateCmsErrorStatistics(CmsErrorFileEntry entry, boolean isNewLogEntry)
    {
        errorFileRecordCount++;
        
        String formNumber = (String)entry.getFormNumber();
        
        if (formNumber != null)
        {
            //letter type and number per type
            Integer cnt = (Integer)errorPerTypeNumberTable.get(formNumber);
            if (cnt == null) //new form is found, initialize with count 1
                errorPerTypeNumberTable.put(formNumber, new Integer(1));
            else //existing form
                if (isNewLogEntry) //since one letter can have multiple error entries, only increment count by 1 if it's a new log entry
                    errorPerTypeNumberTable.put(formNumber, new Integer(cnt.intValue()+1));
        
            String errorCode = entry.getErrorCode();
            
            if (errorCode != null)
            {
                //for each letter type (form number), the error reasons
                Set errorReasons = (Set) errorReasonPerLetterTypeTable.get(formNumber);

                if (errorReasons == null)
                {
                    //new form is found, initialize with a new set
                    Set newCode = new HashSet();
                    newCode.add(errorCode);
                    errorReasonPerLetterTypeTable.put(formNumber, newCode);
                }
                else
                    errorReasons.add(entry.getErrorCode());
            }
        }   
    }    
    
	//    5255[UC17.4.4]  
	//    The system captures and stores the following statistics that will be used to generate a report:
	//    Date/Time File Received
	//    File Name
	//    Number of Error Records Per File
	//    Break out the letters by type and how many per type
	//    For each letter type, the error reason 
    public void updateRejectStatistics(RejectFileEntry entry)
    {
        rejectFileRecordCount++;
        
        String formNumber = (String)entry.getFormNumber();
        
        if (formNumber != null)
        {
            //letter type and number per letter type
            Integer cnt = (Integer)rejectPerTypeNumberTable.get(formNumber);
            if (cnt == null)
                rejectPerTypeNumberTable.put(formNumber, new Integer(1));
            else
                rejectPerTypeNumberTable.put(formNumber, new Integer(cnt.intValue()+1));
        
            String rejectCode = entry.getCode1Reject();
            
            if (rejectCode != null)
            {
                //for each letter type (form number), the reject reasons
                Set rejectReasons = (Set) rejectReasonPerLetterTypeTable.get(formNumber);

                if (rejectReasons == null)
                {
                    Set newCode = new HashSet();
                    newCode.add(rejectCode);
                    rejectReasonPerLetterTypeTable.put(formNumber, newCode);
                }
                else
                    rejectReasons.add(entry.getCode1Reject());
            }
        }   
        
    }

    public void updateCmsRejectStatistics(CmsRejectFileEntry entry) {
        rejectFileRecordCount++;
        
        String formNumber = (String)entry.getFormNumber();
        
        if (formNumber != null)
        {
            //letter type and number per letter type
            Integer cnt = (Integer)rejectPerTypeNumberTable.get(formNumber);
            if (cnt == null)
                rejectPerTypeNumberTable.put(formNumber, new Integer(1));
            else
                rejectPerTypeNumberTable.put(formNumber, new Integer(cnt.intValue()+1));
        
            String rejectCode = entry.getCode1Reject();
            
            if (rejectCode != null)
            {
                //for each letter type (form number), the reject reasons
                Set rejectReasons = (Set) rejectReasonPerLetterTypeTable.get(formNumber);

                if (rejectReasons == null)
                {
                    Set newCode = new HashSet();
                    newCode.add(rejectCode);
                    rejectReasonPerLetterTypeTable.put(formNumber, newCode);
                }
                else
                    rejectReasons.add(entry.getCode1Reject());
            }
        }   
        
    }    
    
	//    5249[UC17.3.5] 
	//    The system captures and stores the following statistics that will be used to generate a report.:
	//    Date/Time File Received
	//    File Name
	//    Number of Records Per File
	//    Break out the letters by type and how many per type.     
    public void updateMailedStatistics(MailedFileEntry entry)
    {
        mailedFileRecordCount++;
        
        String formNumber = (String)entry.getFormNumber();
        
        if (formNumber != null)
        {
            //letter type and number per letter type
            Integer cnt = (Integer)mailedPerTypeNumberTable.get(formNumber);
            if (cnt == null)
                mailedPerTypeNumberTable.put(formNumber, new Integer(1));
            else
                mailedPerTypeNumberTable.put(formNumber, new Integer(cnt.intValue()+1));
        }   
    }
    public void updateCmsMailedStatistics(CmsMailedFileEntry entry)
    {
        mailedFileRecordCount++;
        
        String formNumber = (String)entry.getFormNumber();
        
        if (formNumber != null)
        {
            //letter type and number per letter type
            Integer cnt = (Integer)mailedPerTypeNumberTable.get(formNumber);
            if (cnt == null)
                mailedPerTypeNumberTable.put(formNumber, new Integer(1));
            else
                mailedPerTypeNumberTable.put(formNumber, new Integer(cnt.intValue()+1));
        }   
    }    

    
    /**
     * @return Returns the errorFileDate.
     */
    public Date getErrorFileReceivedDate() {
        return errorFileReceivedDate;
    }
    /**
     * @param errorFileDate The errorFileDate to set.
     */
    public void setErrorFileReceivedDate(Date errorFileReceivedDate) {
        this.errorFileReceivedDate = errorFileReceivedDate;
    }
    /**
     * @return Returns the errorFileName.
     */
    public String getErrorFileName() {
        return errorFileName;
    }
    /**
     * @param errorFileName The errorFileName to set.
     */
    public void setErrorFileName(String errorFileName) {
        this.errorFileName = errorFileName;
    }
    /**
     * @return Returns the mailedFileDate.
     */
    public Date getMailedFileReceivedDate() {
        return mailedFileReceivedDate;
    }
    /**
     * @param mailedFileDate The mailedFileDate to set.
     */
    public void setMailedFileReceivedDate(Date mailedFileReceivedDate) {
        this.mailedFileReceivedDate = mailedFileReceivedDate;
    }
    /**
     * @return Returns the mailedFileName.
     */
    public String getMailedFileName() {
        return mailedFileName;
    }
    /**
     * @param mailedFileName The mailedFileName to set.
     */
    public void setMailedFileName(String mailedFileName) {
        this.mailedFileName = mailedFileName;
    }
    /**
     * @return Returns the rejectFileDate.
     */
    public Date getRejectFileReceivedDate() {
        return rejectFileReceivedDate;
    }
    /**
     * @param rejectFileDate The rejectFileDate to set.
     */
    public void setRejectFileReceivedDate(Date rejectFileReceivedDate) {
        this.rejectFileReceivedDate = rejectFileReceivedDate;
    }
    /**
     * @return Returns the rejectFileName.
     */
    public String getRejectFileName() {
        return rejectFileName;
    }
    /**
     * @param rejectFileName The rejectFileName to set.
     */
    public void setRejectFileName(String rejectFileName) {
        this.rejectFileName = rejectFileName;
    }
    
    
    /**
     * @return Returns the errorFileRecordCount.
     */
    public int getErrorFileRecordCount() {
        return errorFileRecordCount;
    }
    /**
     * @return Returns the errorPerTypeNumberTable.
     */
    public Hashtable getErrorPerTypeNumberTable() {
        return errorPerTypeNumberTable;
    }
    /**
     * @return Returns the errorReasonPerLetterTypeTable.
     */
    public Hashtable getErrorReasonPerLetterTypeTable() {
        return errorReasonPerLetterTypeTable;
    }
    /**
     * @return Returns the mailedFileRecordCount.
     */
    public int getMailedFileRecordCount() {
        return mailedFileRecordCount;
    }
    /**
     * @return Returns the mailedPerTypeNumberTable.
     */
    public Hashtable getMailedPerTypeNumberTable() {
        return mailedPerTypeNumberTable;
    }
    /**
     * @return Returns the rejectFileRecordCount.
     */
    public int getRejectFileRecordCount() {
        return rejectFileRecordCount;
    }
    /**
     * @return Returns the rejectPerTypeNumberTable.
     */
    public Hashtable getRejectPerTypeNumberTable() {
        return rejectPerTypeNumberTable;
    }
    /**
     * @return Returns the rejectReasonPerLetterTypeTable.
     */
    public Hashtable getRejectReasonPerLetterTypeTable() {
        return rejectReasonPerLetterTypeTable;
    }
    /**
     * @return Returns the processEndTime.
     */
    public Date getProcessEndTime() {
        return processEndTime;
    }
    /**
     * @param processEndTime The processEndTime to set.
     */
    public void setProcessEndTime(Date processEndTime) {
        this.processEndTime = processEndTime;
    }
    /**
     * @return Returns the processStartTime.
     */
    public Date getProcessStartTime() {
        return processStartTime;
    }
    /**
     * @param processStartTime The processStartTime to set.
     */
    public void setProcessStartTime(Date processStartTime) {
        this.processStartTime = processStartTime;
    }
    /**
     * @return Returns the errorFileProcessEndTime.
     */
    public Date getErrorFileProcessEndTime() {
        return errorFileProcessEndTime;
    }
    /**
     * @param errorFileProcessEndTime The errorFileProcessEndTime to set.
     */
    public void setErrorFileProcessEndTime(Date errorFileProcessEndTime) {
        this.errorFileProcessEndTime = errorFileProcessEndTime;
    }
    /**
     * @return Returns the errorFileProcessStartTime.
     */
    public Date getErrorFileProcessStartTime() {
        return errorFileProcessStartTime;
    }
    /**
     * @param errorFileProcessStartTime The errorFileProcessStartTime to set.
     */
    public void setErrorFileProcessStartTime(Date errorFileProcessStartTime) {
        this.errorFileProcessStartTime = errorFileProcessStartTime;
    }
    /**
     * @return Returns the mailedFileProcessEndTime.
     */
    public Date getMailedFileProcessEndTime() {
        return mailedFileProcessEndTime;
    }
    /**
     * @param mailedFileProcessEndTime The mailedFileProcessEndTime to set.
     */
    public void setMailedFileProcessEndTime(Date mailedFileProcessEndTime) {
        this.mailedFileProcessEndTime = mailedFileProcessEndTime;
    }
    /**
     * @return Returns the mailedFileProcessStartTime.
     */
    public Date getMailedFileProcessStartTime() {
        return mailedFileProcessStartTime;
    }
    /**
     * @param mailedFileProcessStartTime The mailedFileProcessStartTime to set.
     */
    public void setMailedFileProcessStartTime(Date mailedFileProcessStartTime) {
        this.mailedFileProcessStartTime = mailedFileProcessStartTime;
    }
    /**
     * @return Returns the rejectFileProcessEndTime.
     */
    public Date getRejectFileProcessEndTime() {
        return rejectFileProcessEndTime;
    }
    /**
     * @param rejectFileProcessEndTime The rejectFileProcessEndTime to set.
     */
    public void setRejectFileProcessEndTime(Date rejectFileProcessEndTime) {
        this.rejectFileProcessEndTime = rejectFileProcessEndTime;
    }
    /**
     * @return Returns the rejectFileProcessStartTime.
     */
    public Date getRejectFileProcessStartTime() {
        return rejectFileProcessStartTime;
    }
    /**
     * @param rejectFileProcessStartTime The rejectFileProcessStartTime to set.
     */
    public void setRejectFileProcessStartTime(Date rejectFileProcessStartTime) {
        this.rejectFileProcessStartTime = rejectFileProcessStartTime;
    }

    public int getErrorFileFailedCount() {
        return errorFileFailedCount;
    }

    public void incrementErrorFileFailedCount() {
        this.errorFileFailedCount++;
    }

    public int getErrorFileProcessedCount() {
        return errorFileProcessedCount;
    }

    public void incrementErrorFileProcessedCount() {
        this.errorFileProcessedCount++;
    }


    public int getRejectFileFailedCount() {
        return rejectFileFailedCount;
    }

    public void incrementRejectFileFailedCount() {
        this.rejectFileFailedCount++;
    }

    public int getRejectFileProcessedCount() {
        return rejectFileProcessedCount;
    }

    public void incrementRejectFileProcessedCount() {
        this.rejectFileProcessedCount++;
    }

    
    public int getMailedFileFailedCount() {
        return mailedFileFailedCount;
    }

    public void incrementMailedFileFailedCount() {
        this.mailedFileFailedCount++;
    }

    public int getMailedFileProcessedCount() {
        return mailedFileProcessedCount;
    }

    public void incrementMailedFileProcessedCount() {
        this.mailedFileProcessedCount++;
    }
	public int getReturnedMailFileProcessedCount() {
		return returnedMailFileProcessedCount;
	}
	public void incrementReturnedMailFileProcessedCount() {
		this.returnedMailFileProcessedCount++;
	}
    
    
}
