package gov.va.med.esr.common.model.comms;

import gov.va.med.esr.service.trigger.BulletinTrigger;
import gov.va.med.fw.model.AbstractKeyedEntity;

import java.io.Serializable;
import java.util.HashMap;


/**
 *        @hibernate.class
 *         table="COMMS_BULLETIN"
 *
*/
public class CommsBulletin extends AbstractKeyedEntity
	implements Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;
	public static String VETERAN_SITES = "1";
	public static String SENDING_SITE = "2";

    /** nullable persistent field */
    private String commsBulletinText;

    /** nullable persistent field */
    private String commsBulletinName;

    private String recipientList;
    private String subject;


    private String description;

    private String siteRecipientPrefixList;
    private String siteReceivingIndicator;

    /** default constructor */
    public CommsBulletin() {
    }


    /**
     *            @hibernate.property
     *             column="COMMS_BULLETIN_TEXT"
     *             length="4000"
     *
     */
    public String getCommsBulletinText() {
        return this.commsBulletinText;
    }

    public void setCommsBulletinText(String commsBulletinText) {
        this.commsBulletinText = commsBulletinText;
    }


    /**
     *            @hibernate.property
     *             column="COMMS_BULLETIN_NAME"
     *             length="250"
     *
     */
    public String getCommsBulletinName() {
        return this.commsBulletinName;
    }

    public void setCommsBulletinName(String commsBulletinName) {
        this.commsBulletinName = commsBulletinName;
    }

    /**
     * @return Returns the description.
     */
    public String getDescription() {
        return description;
    }
    /**
     * @param description The description to set.
     */
    public void setDescription(String description) {
        this.description = description;
    }
    /**
     * @return Returns the recipient.
     */
    public String getRecipient() {
        return recipientList;
    }
    /**
     * @param recipient The recipient to set.
     */
    public void setRecipient(String recipientList) {
        this.recipientList = recipientList;
    }
    /**
     * @return Returns the subject.
     */
    public String getSubject() {
        return subject;
    }
    /**
     * @param subject The subject to set.
     */
    public void setSubject(String subject) {
        this.subject = subject;
    }

    // Move siteRecipientPrefixList, siteReceivingIndicator to database??
	public String getSiteRecipientPrefixList() {
		return siteRecipientPrefixList;
	}


	public void setSiteRecipientPrefixList(String siteRecipientPrefixList) {
		this.siteRecipientPrefixList = siteRecipientPrefixList;
	}

	public String getSiteReceivingIndicator() {
		return siteReceivingIndicator;
	}


	public void setSiteReceivingIndicator(String siteReceivingIndicator) {
		this.siteReceivingIndicator = siteReceivingIndicator;
	}
}
