package gov.va.med.esr.common.model.comms;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CmsMailedFileEntry {

	private String formNumber;
	private String barCode;
	private String vpid;
	private String ivmCaseNumber;	
	private String mailedDate;	
	private String communicationId;
	
	
	public CmsMailedFileEntry(String formNumber, String barCode, String vpid, 
			String ivmCaseNumber, String mailedDate, String communicationId) {
		this.formNumber = formNumber;
		this.barCode = barCode;
		this.vpid = vpid;
		this.ivmCaseNumber = ivmCaseNumber;
		this.mailedDate = mailedDate;
		this.communicationId = communicationId;		
	}

	public String getFormNumber() {
		return formNumber;
	}

	public String getBarCode() {
		return barCode;
	}

	public String getCommunicationId() {
		return communicationId;
	}

	public Date getMailedDate() {
        if (mailedDate != null && mailedDate.length() == 8)
		{
        	try {
            //"MMddyyyy"
        	Date date = new SimpleDateFormat("MMddyyyy").parse(mailedDate);
            
            return date;
        	}
        	catch (ParseException e) {
        		throw new RuntimeException("Invalid date format");
        	}
		}
        return null;		
	}

	public String getVpid() {
		return vpid;
	}

	public String getIvmCaseNumber() {
		return ivmCaseNumber;
	}
}
