/*****************************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ****************************************************************************************/
package gov.va.med.esr.common.model.cases;

import gov.va.med.person.idmgmt.VPID;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.PersonTraits;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.service.PersonIdentityTraits;

public class WorkflowPerson extends AbstractKeyedEntity {

   /**
    * An instance of serialVersionUID
    */
   private static final long serialVersionUID = -7772508002556778606L;

   private PersonTraits personTraits = null;

   private String VPIDValue;

   // TODO to be deleted
   public VPIDEntityKey getVPIDEntityKey() {
      return ( VPIDValue != null ) ? CommonEntityKeyFactory
            .createVPIDEntityKey(VPIDValue) : null;
   }

   public PersonTraits getPersonTraits() {
      return this.personTraits;
   }

   public void setPersonTraits(PersonTraits personTraits) {
      this.personTraits = personTraits;
   }

   public void setPersonTraits(PersonIdentityTraits identityTraits) {
      if( this.personTraits == null )
         this.personTraits = new PersonTraits();
      this.personTraits.setTraits(identityTraits);
   }

   private String getVPIDValue() {
      return VPIDValue;
   }

   private void setVPIDValue(String VPIDValue) {
      this.VPIDValue = VPIDValue;
   }

   public String getName() {
      return personTraits == null ? "" : personTraits.getFormattedName();
   }

   public String getSsn() {
      return personTraits == null ? "" : personTraits.getSsn();
   }

   public String getShortVPID() {
      return VPID.getShortVPID(getVPIDValue());
   }

   /**
    * @see gov.va.med.fw.model.AbstractKeyedEntity#finalize()
    */
   protected void finalize() throws Throwable {
      super.finalize();
      setVPIDValue( null );
   }
}
