/*****************************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ****************************************************************************************/
package gov.va.med.esr.common.model.cases;

import java.math.BigDecimal;
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.lookup.WkfCaseActivityType;
import gov.va.med.esr.common.model.lookup.WkfCaseRequestType;
import gov.va.med.esr.common.model.lookup.WkfCaseStatusType;

/**
 * History instance of Status
 * 
 * @author DNS   KATIKM
 */
public class StatusHistory extends AbstractKeyedEntity implements Comparable {
   /**
    * An instance of serialVersionUID
    */
   private static final long serialVersionUID = 429182886390454190L;

   private WkfCaseStatusType statusValue = null;

   private WkfCaseRequestType reasonType = null;

   private WkfCaseActivityType activityType = null;

   private BigDecimal workflowCaseId = null;

   public StatusHistory() {
      super();
   }

   public WkfCaseActivityType getActivityType() {
      return activityType;
   }

   public WkfCaseRequestType getReasonType() {
      return reasonType;
   }

   public WkfCaseStatusType getStatusValue() {
      return statusValue;
   }

   public void setActivityType(WkfCaseActivityType activityType) {
      this.activityType = activityType;
   }

   public void setReasonType(WkfCaseRequestType reasonType) {
      this.reasonType = reasonType;
   }

   public void setStatusValue(WkfCaseStatusType statusValue) {
      this.statusValue = statusValue;
   }

   /*
    * (non-Javadoc)
    * 
    * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
    */
   public void buildToString(ToStringBuilder builder) {
      super.buildToString(builder);
      builder.append("Status.statusValue", this.statusValue);
      builder.append("Status.reasonType", this.reasonType);
      builder.append("Status.activityType", this.activityType);
   }

   public int compareTo(Object obj) {
      if( obj != null && obj instanceof StatusHistory ) {
         Date otherModifiedDate = ( (StatusHistory)obj ).getModifiedOn();
         Date modifiedDate = getModifiedOn();
         if( modifiedDate != null && otherModifiedDate != null ) {
            return modifiedDate.compareTo(otherModifiedDate);
         }
         else if( modifiedDate != null ) {
            return 1;
         }
         else if( otherModifiedDate != null ) {
            return -1;
         }
      }
      return 0;
   }
   
   /**
    * @see gov.va.med.fw.model.AbstractKeyedEntity#finalize()
    */
   protected void finalize() throws Throwable {
      super.finalize();
      if( this.getWorkflowCaseId() != null ) {
         this.setWorkflowCaseId( null );
      }
   }

   private BigDecimal getWorkflowCaseId() {
      return workflowCaseId;
   }

   private void setWorkflowCaseId(BigDecimal workflowCaseId) {
      this.workflowCaseId = workflowCaseId;
   }

}
