package gov.va.med.esr.common.model.cases;

import java.math.BigDecimal;
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.lookup.WkfCaseActivityType;
import gov.va.med.esr.common.model.lookup.WkfCaseRequestType;
import gov.va.med.esr.common.model.lookup.WkfCaseStatusType;

/**
 * The status is the current phase case. The status value acts as a progress indicator as
 * the case activities are completed. Valid status values: new, in process, closed
 * assigned, adjudicated,
 */

public class Status extends AbstractKeyedEntity implements Comparable {
   /**
    * An instance of serialVersionUID
    */
   private static final long serialVersionUID = -7493369156526973153L;

   private WorkflowCase workflowCase = null;

   private WkfCaseStatusType statusValue = null;

   private WkfCaseRequestType reasonType = null;

   private WkfCaseActivityType activityType = null;

   public Status() {
      super();
   }

   public WkfCaseActivityType getActivityType() {
      return activityType;
   }

   public WkfCaseRequestType getReasonType() {
      return reasonType;
   }

   public WkfCaseStatusType getStatusValue() {
      return statusValue;
   }

   public WorkflowCase getWorkflowCase() {
      return workflowCase;
   }

   public void setActivityType(WkfCaseActivityType activityType) {
      this.activityType = activityType;
   }

   public void setReasonType(WkfCaseRequestType reasonType) {
      this.reasonType = reasonType;
   }

   public void setStatusValue(WkfCaseStatusType statusValue) {
      this.statusValue = statusValue;
   }

   public void setWorkflowCase(WorkflowCase workflowCase) {
      this.workflowCase = workflowCase;
   }

   /**
    * @return Returns the statusID.
    */
   public BigDecimal getStatusID() {
      return (BigDecimal)( getEntityKey() == null ? null : getEntityKey().getKeyValue() );
   }

   public BigDecimal getWorkflowCaseID() {
      if( getWorkflowCase() == null || getWorkflowCase().getEntityKey() == null ) {
         return null;
      }
      else {
         return (BigDecimal)getWorkflowCase().getEntityKey().getKeyValue();
      }
   }

   /*
    * (non-Javadoc)
    * 
    * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
    */
   public void buildToString(ToStringBuilder builder) {
      super.buildToString(builder);
      builder.append("Status.statusValue", this.statusValue);
      builder.append("Status.reasonType", this.reasonType);
      builder.append("Status.activityType", this.activityType);
   }

   public int compareTo(Object obj) {
      if( obj != null && obj instanceof Status ) {
         Date otherCreateDate = ( (Status)obj ).getCreatedOn();
         Date createDate = getCreatedOn();
         if( createDate != null && otherCreateDate != null ) {
            return createDate.compareTo(otherCreateDate);
         }
         else if( createDate != null ) {
            return 1;
         }
         else if( otherCreateDate != null ) {
            return -1;
         }
      }
      return 0;
   }
}
