package gov.va.med.esr.common.model.cases;

import java.math.BigDecimal;
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;
import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * Freeform text which may be entered by the user to document pertinent information
 * regarding the case. Updated Madhu Katikala
 */

public class Comment extends AbstractKeyedEntity implements Comparable {
   
   /**
    * An instance of serialVersionUID
    */
   private static final long serialVersionUID = 7876010721179509794L;

   private WorkflowCase workflowCase = null;

   private String commentText = null;

   public Comment() {
      super();
   }

   public String getCommentText() {
      return commentText;
   }

   public WorkflowCase getWorkflowCase() {
      return workflowCase;
   }

   public void setCommentText(String commentText) {
      this.commentText = commentText;
   }

   public void setWorkflowCase(WorkflowCase workflowCase) {
      this.workflowCase = workflowCase;
   }

   public BigDecimal getCommentID() {
      return (BigDecimal)( getEntityKey() == null ? null : getEntityKey().getKeyValue() );
   }

   /*
    * (non-Javadoc)
    * 
    * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
    */
   public void buildToString(ToStringBuilder builder) {
      super.buildToString(builder);
      builder.append("Comment.commentText", this.commentText);
   }

   /**
    * Ordered by the Create Date
    */

   public int compareTo(Object obj) {
      // if the create date is null - current comment comes first
      if( getCreatedOn() == null || obj == null )
         return 1;

      if( obj instanceof Comment ) {
         Date otherDate = ( (Comment)obj ).getCreatedOn();
         return ( otherDate == null ) ? -1 : getCreatedOn().compareTo(otherDate);
      }
      return 1;
   }
}
