/*****************************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ****************************************************************************************/
package gov.va.med.esr.common.model.cases;

import java.math.BigDecimal;
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * History Instance of Assignment
 * 
 * @author DNS   KATIKM
 */
public class AssignmentHistory extends AbstractKeyedEntity implements Comparable {

   /**
    * An instance of serialVersionUID
    */
   private static final long serialVersionUID = 2468391607243582586L;

   private String assignedTo = null;

   private String assignedBy = null;

   private Date assignmentDate = new Date();

   private BigDecimal workflowCaseId = null;

   public AssignmentHistory() {
      super();
   }

   public String getAssignedBy() {
      return assignedBy;
   }

   public String getAssignedTo() {
      return assignedTo;
   }

   public Date getAssignmentDate() {
      return assignmentDate;
   }

   public void setAssignedBy(String assignedBy) {
      this.assignedBy = assignedBy;
   }

   public void setAssignedTo(String assignedTo) {
      this.assignedTo = assignedTo;
   }

   public void setAssignmentDate(Date assignmentDate) {
      this.assignmentDate = assignmentDate;
   }

   public void buildToString(ToStringBuilder builder) {
      super.buildToString(builder);
      builder.append("Assignment.assignedTo", this.assignedTo);
      builder.append("Assignment.assignedBy", this.assignedBy);
      builder.append("Assignment.assignmentDate", this.assignmentDate);
   }

   public int compareTo(Object obj) {
      if( obj != null && obj instanceof AssignmentHistory ) {
         Date otherAssigmentDate = ( (AssignmentHistory)obj ).getAssignmentDate();
         if( assignmentDate != null && otherAssigmentDate != null ) {
            return assignmentDate.compareTo(otherAssigmentDate);
         }
         else if( assignmentDate != null ) {
            return 1;
         }
         else if( otherAssigmentDate != null ) {
            return -1;
         }
      }
      return 0;
   }
   
   /**
    * @see gov.va.med.fw.model.AbstractKeyedEntity#finalize()
    */
   protected void finalize() throws Throwable {
      super.finalize();
      if( this.getWorkflowCaseId() != null ) {
         this.setWorkflowCaseId( null );
      }
   }

   private BigDecimal getWorkflowCaseId() {
      return workflowCaseId;
   }

   private void setWorkflowCaseId(BigDecimal workflowCaseId) {
      this.workflowCaseId = workflowCaseId;
   }
}