package gov.va.med.esr.common.model.cases;

import java.math.BigDecimal;
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.util.DateUtils;

/**
 * Records the user assigned to work the case. There may be multiple occurances of this
 * since cases may be reassigned. Updated Madhu Katikala
 */

public class Assignment extends AbstractKeyedEntity implements Comparable {

   /**
    * An instance of serialVersionUID
    */
   private static final long serialVersionUID = -5328997034827424491L;

   private WorkflowCase workflowCase;

   private String assignedTo = null;

   private String assignedBy = null;

   private Date assignmentDate = null;

   public Assignment() {
      super();
   }

   public String getAssignedBy() {
      return assignedBy;
   }

   public String getAssignedTo() {
      return assignedTo;
   }

   public Date getAssignmentDate() {
      return assignmentDate;
   }

   public WorkflowCase getWorkflowCase() {
      return workflowCase;
   }

   public void setAssignedBy(String assignedBy) {
      this.assignedBy = assignedBy;
   }

   public void setAssignedTo(String assignedTo) {
      this.assignedTo = assignedTo;
      if( assignedTo != null && assignmentDate == null ) {
         assignmentDate = DateUtils.getCurrentDate();
      }
   }

   public void setAssignmentDate(Date assignmentDate) {
      this.assignmentDate = assignmentDate;
   }

   public void setWorkflowCase(WorkflowCase workflowCase) {
      this.workflowCase = workflowCase;
   }

   public BigDecimal getAssignmentID() {
      return (BigDecimal)( getEntityKey() == null ? null : getEntityKey().getKeyValue() );
   }

   public BigDecimal getWorkflowCaseID() {
      if( getWorkflowCase() == null || getWorkflowCase().getEntityKey() == null ) {
         return null;
      }
      else {
         return (BigDecimal)getWorkflowCase().getEntityKey().getKeyValue();
      }
   }

   /**
    * (non-Javadoc)
    * 
    * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
    */
   public void buildToString(ToStringBuilder builder) {
      super.buildToString(builder);
      builder.append("Assignment.assignedTo", this.assignedTo);
      builder.append("Assignment.assignedBy", this.assignedBy);
      builder.append("Assignment.assignmentDate", this.assignmentDate);
   }

   public int compareTo(Object obj) {
      if( obj != null && obj instanceof Assignment ) {
         Date otherAssigmentDate = ( (Assignment)obj ).getAssignmentDate();
         if( assignmentDate != null && otherAssigmentDate != null ) {
            return assignmentDate.compareTo(otherAssigmentDate);
         }
         else if( assignmentDate != null ) {
            return 1;
         }
         else if( otherAssigmentDate != null ) {
            return -1;
         }
      }
      return 0;
   }
}
