/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/

package gov.va.med.esr.common.model;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractEntity;

import gov.va.med.esr.common.model.lookup.VAFacility;

/**
 * SiteYear is used as a composite index for few BOM's where data is need to be
 * stored per year per site.
 * 
 * @author DNS   MANSOG
 * @version 1.0
 */
public class SiteYear extends AbstractEntity {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6164462925722298280L;

	private Integer year = null;

	private VAFacility facility = null;

	public SiteYear() {
		super();
	}

	public SiteYear(Integer year, VAFacility facility) {
		this.year = year;
		this.facility = facility;
	}

	public VAFacility getFacility() {
		return facility;
	}

	public void setFacility(VAFacility facility) {
		this.facility = facility;
	}

	public Integer getYear() {
		return year;
	}

	public void setYear(Integer year) {
		this.year = year;
	}

	/**
	 * buildToString
	 * 
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		builder.append("Year", year);
		builder.append("Facility", facility);
	}
}