package gov.va.med.esr.common.io;

import java.io.File;
import java.io.FileFilter;
import java.util.Locale;

public class PDFFilter implements FileFilter
{
  private final String[] okFileExtensions = new String[] {("1095B_2015.pdf")};

  public boolean accept(File file)
  {
    for (String extension : okFileExtensions)
    {
      if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(extension))
      {
        return true;
      }
    }
    return false;
  }
}
