package gov.va.med.esr.common.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class FileUtility {
	public static String mergeLines(String[] lines) {
		StringBuffer sb = new StringBuffer();
		for(int i = 0; i < lines.length; i++){
			sb.append(lines[i]);
		}
		
		return sb.toString();
	}
	public static void writeFile(File file, String fileContent) throws IOException {
		FileOutputStream out = null;
		try {
			out = new FileOutputStream(file);
			out.write(fileContent.getBytes());
		} finally {
			if (out != null) {
				out.close();
			}
		}
	}
	public static String[] readFile(File file) throws IOException{
		ArrayList<String> lines = new ArrayList<String>();
		BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
		String line;
		
		try{
			while((line = reader.readLine()) != null){
				lines.add(line);
			}
		} finally{
			if(reader != null) reader.close();
		}
		return lines.toArray(new String[lines.size()]);
	}
	
	public static String readFileAsString(File file) throws IOException{
		return mergeLines(readFile(file));
	}
}
