/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
/*
 * Created on Mar 14, 2005
 *
 */
package gov.va.med.esr.common.infra;

// Java classes
import java.io.Serializable;

// Library classes

// Framework classes

// EDB Classes

/**
 * Represent a type that has 3 possible states: Yes, No, Unknown
 * @author Yi He
 * @version 1.0
 */
public class TriState implements Serializable {
	
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 4000498397434808954L;
	
	private static final String KEY_TRUE = "Yes";
	private static final String KEY_FALSE = "No";
	private static final String KEY_UNKNOWN = "Unknown";

	public static final TriState TRUE = new TriState(KEY_TRUE);
	public static final TriState FALSE = new TriState(KEY_FALSE);
	public static final TriState UNKNOWN = new TriState(KEY_UNKNOWN);
		
	
	/**
	 * @param state The state value is not YES, NO or UNKNOWN, it will be
	 * treated as UNKNOWN
	 */
	private TriState(String state) {
		super();
        this.state = state;
    }

	public boolean equals(Object obj) {
		if(!(obj instanceof TriState))
			return false;
		
		TriState another = (TriState)obj;
		return this.state.equals(another.state);
	}
	
	public int hashCode() {
		return this.state.hashCode();
	}

	public String toString() {
		return state;
	}
	
	private String state = null;
}
