/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.infra;

// Java Classes
import java.io.Serializable;

// Library Classes
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;

// Framework Classes

// Common Classes

/**
 * @author Martin Francisco
 */
public class PredicatedTransformer implements Transformer, Serializable {
	
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6370542198351268517L;

	private Predicate predicate;

	private Transformer transformer;

	public static Transformer getInstance(Transformer transformer,
			Predicate predicate) {
		return new PredicatedTransformer(transformer, predicate);
	}

	private PredicatedTransformer(Transformer transformer, Predicate predicate) {
		super();

		this.transformer = transformer;
		this.predicate = predicate;
	}

	public Predicate getPredicate() {
		return this.predicate;
	}

	public Transformer getTransformer() {
		return this.transformer;
	}

	protected void validate(Object object) {
		if (this.predicate.evaluate(object) == false) {
			throw new IllegalArgumentException("Cannot transform Object '"
					+ object + "' - Predicate rejected it");
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.apache.commons.collections.Transformer#transform(java.lang.Object)
	 */
	public Object transform(Object input) {
		this.validate(input);
		return this.transformer.transform(input);
	}
}