package gov.va.med.esr.common.infra;

// Java classes
import java.util.Calendar;

// Library classes

// Framework classes

// ESR classes

/**
 * @author DNS   ruizc
 */
public class PreciseDateUtils {

    public PreciseDateUtils() {
        super();
    }

    /**
     * Bin's getDays method to return the number of days
     * between two dates.
     * 
     * @param fromCalenda
     * @param toCalendar
     * @return
     */
    public static Long getDays(Calendar fromCalenda, Calendar toCalendar)
    {   
        if (toCalendar == null || fromCalenda == null)
            return null;
   
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(fromCalenda.get(Calendar.YEAR), fromCalenda.get(Calendar.MONTH), fromCalenda.get(Calendar.DAY_OF_MONTH));
        long fromDateMilliseconds = calendar.getTime().getTime();

        calendar.clear();
        calendar.set(toCalendar.get(Calendar.YEAR), toCalendar.get(Calendar.MONTH), toCalendar.get(Calendar.DAY_OF_MONTH));
        long toDateMilliseconds = calendar.getTime().getTime();

        long msPerDay = 1000 * 60 * 60 * 24;
        long result = (toDateMilliseconds - fromDateMilliseconds) / msPerDay;
            
        return new Long(result + 1);  //return 1 for same date.
    }
}
