/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.infra;

// Java Classes
import java.util.Calendar;
import java.util.Date;

// Library Classes

// Framework Classes
import gov.va.med.fw.util.DateUtils;

// Common Classes

/**
 * @author Martin Francisco
 */
public class ImpreciseDateUtils {
	public static final int DEFAULT_DAY = 15;

	public static final int DEFAULT_MONTH = Calendar.JUNE;
	
	public static final int DEFAULT_Reconciliation_DAY = 1;
	
	public static final int DEFAULT_Reconciliation_MONTH = Calendar.JANUARY;
	
	public static final String YYYYMMDD = "yyyyMMdd";

	public static Date getDateWithDefault(ImpreciseDate value) {
		return ImpreciseDateUtils.getDateWithDefault(value,
				ImpreciseDateUtils.DEFAULT_MONTH, ImpreciseDateUtils.DEFAULT_DAY);
	}
	
	public static Date getReconcilitationDateWithDefault(ImpreciseDate value) {
		return ImpreciseDateUtils.getDateWithDefault(value,
				ImpreciseDateUtils.DEFAULT_Reconciliation_MONTH, ImpreciseDateUtils.DEFAULT_Reconciliation_DAY);
	}

	public static Date getDateWithDefault(ImpreciseDate value, int defaultMonth,
			int defaultDay) {
		if (value == null) {
			return null;
		}
		else if (value.isPrecise()) {
			return value.getDate();
		}
		else if (value.isMonthPrecise()) {
			Calendar calendar = (new ImpreciseDateStringFormat(value.getString()))
					.getCalendar();
			calendar.set(Calendar.DAY_OF_MONTH, defaultDay);
			return calendar.getTime();
		}
		else {
			Calendar calendar = (new ImpreciseDateStringFormat(value.getString()))
					.getCalendar();
			calendar.set(Calendar.MONTH, defaultMonth);
			calendar.set(Calendar.DAY_OF_MONTH, defaultDay);
			return calendar.getTime();
		}
	}	
	

	public static ImpreciseDate createImpreciseDate(int year) {
		return new ImpreciseDate(DateUtils.createCalendar(year));
	}

	public static ImpreciseDate createImpreciseDate(int year, int month) {
		return new ImpreciseDate(DateUtils.createCalendar(year, month));
	}

	public static ImpreciseDate createImpreciseDate(int year, int month, int day) {
		return new ImpreciseDate(DateUtils.createCalendar(year, month, day));
	}

	public static ImpreciseDate createImpreciseDateWithoutTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(Calendar.YEAR);
        int month = calendar.get(Calendar.MONTH);
        int day = calendar.get(Calendar.DATE);
        calendar.clear();
        calendar.set(year,month,day);        
        return new ImpreciseDate(calendar);
	}
	
	public static ImpreciseDate createImpreciseDate(int year, int month, int day,
			int hour) {
		return new ImpreciseDate(DateUtils.createCalendar(year, month, day, hour));
	}

	public static ImpreciseDate createImpreciseDate(int year, int month, int day,
			int hour, int minute) {
		return new ImpreciseDate(DateUtils.createCalendar(year, month, day, hour, minute));
	}

	public static ImpreciseDate createImpreciseDate(int year, int month, int day,
			int hour, int minute, int second) {
		return new ImpreciseDate(DateUtils.createCalendar(year, month, day, hour, minute,
				second));
	}

	public static ImpreciseDate createImpreciseDate(int year, int month, int day,
			int hour, int minute, int second, int millisecond) {
		return new ImpreciseDate(DateUtils.createCalendar(year, month, day, hour, minute,
				second, millisecond));
	}

	private ImpreciseDateUtils() {
		super();
	}
    
    public static boolean impreciseDatesEqualWithoutTime(ImpreciseDate date1, ImpreciseDate date2)
    {
        
        if(date1 == null && date2 == null)
            return true;        
        if(date1 == null && date2!= null || date1 != null && date2 == null )
            return false;
        // If there is time component, ignore time comonents comparision.
        return date1.getDate() !=null && date2.getDate() !=null ? 
                createImpreciseDateWithoutTime(date1.getDate()).equals(createImpreciseDateWithoutTime(date2.getDate())): date1.equals(date2);
    }
    
}