package gov.va.med.esr.common.clock;

// Java classes

// Library classes

// Framework classes

// ESR classes
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.GenerateQRYZ11MessagingService;
import gov.va.med.esr.service.PersonService;

public class Z11PendingTraitsClockProcess extends AbstractClockProcess {
    private GenerateQRYZ11MessagingService messagingService = null;
    private PersonService personService = null;
    
    public Z11PendingTraitsClockProcess() {
        super();
    }

    protected void processClock(String personId, String clockType, String subject)
            throws Exception {
    	
    	Person person = this.getPersonService().getPerson(
                CommonEntityKeyFactory.createPersonIdEntityKey(personId));
	
    	this.getMessagingService().generateMessageForPendingTraitsClock(person);   	
    }
   
    /**

    /**
     * @param messagingService
     *            The messagingService to set.
     */
    public void setMessagingService(GenerateQRYZ11MessagingService messagingService) {
        this.messagingService = messagingService;
    }

    protected GenerateQRYZ11MessagingService getMessagingService() {
    	return messagingService;
    }

	public PersonService getPersonService() {
		return personService;
	}

	public void setPersonService(PersonService personService) {
		this.personService = personService;
	}

	
    protected Clock.Type convertStrToClockType(String type) {
        // Convert all clock types here
        if (Clock.Type.Z11_10_MIN_CLOCK.getName().equals(type)) {
            return Clock.Type.Z11_10_MIN_CLOCK;
        }
        if (Clock.Type.Z11_10_MIN_CLOCK.getName().equals(type)) {
            return Clock.Type.Z11_10_MIN_CLOCK;
        }
        return null;
    }    
}
