package gov.va.med.esr.common.clock;

import gov.va.med.esr.common.clock.Clock.Type;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.WorkflowService;

public class WorkflowClockProcess extends AbstractClockProcess {
    private PersonService personService = null;	
    private WorkflowService workflowService = null;    
	
	protected Type convertStrToClockType(String type) {
		if (Clock.Type.WF_72_HOUR_CLOCK.getName().equals(type)) {
			return Clock.Type.WF_72_HOUR_CLOCK;
		}
		return null;
	}

	protected void processClock(String personId, String clockType,
			String subject) throws Exception {
		   Person person = this.getPersonService().getPerson(
	                CommonEntityKeyFactory.createPersonIdEntityKey(personId));
	        Clock.Type firedClockType = this.convertStrToClockType(clockType);
	        // The Workflow Clock process is invoked because a clock expired.  
	        // Rather than initiate a trigger event to create a case, 
	        // the workflow service will be directly invoked.
	        this.getWorkflowService().processWorkflowEvent(person, firedClockType);
	}

	public PersonService getPersonService() {
		return personService;
	}

	public void setPersonService(PersonService personService) {
		this.personService = personService;
	}

	public WorkflowService getWorkflowService() {
		return workflowService;
	}

	public void setWorkflowService(WorkflowService workflowService) {
		this.workflowService = workflowService;
	}
}
