package gov.va.med.esr.common.clock;

// Java classes

// Library classes

// Framework classes

// ESR classes
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.CommsLogService;
import gov.va.med.esr.service.PersonService;

/**
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class SSNClockProcess extends AbstractClockProcess {
    private CommsLogService commsLogService = null;
    private PersonService personService = null;  
    
    
    public SSNClockProcess() {
        super();
    }

    protected void processClock(String personId, String clockType, String subject)
            throws Exception {
        Person person = this.getPersonService().getPerson(
                CommonEntityKeyFactory.createPersonIdEntityKey(personId));
        Clock.Type firedClockType = this.convertStrToClockType(clockType);
        // Tell service what clock fired        
        this.getCommsLogService().processAutomaticLetterRequests(person, firedClockType, subject);
    }
    
    protected Clock.Type convertStrToClockType(String type) {
        // Convert all clock types here
        if (Clock.Type.SSN_30_DAY_VALIDATION_CLOCK.getName().equals(type)) {
            return Clock.Type.SSN_30_DAY_VALIDATION_CLOCK;
        }
        if (Clock.Type.SSN_45_DAY_CLOCK.getName().equals(type)) {
            return Clock.Type.SSN_45_DAY_CLOCK;
        }
        if (Clock.Type.SSN_30_DAY_PSEUDO_SSN_REASON_CLOCK.getName().equals(type)) {
            return Clock.Type.SSN_30_DAY_PSEUDO_SSN_REASON_CLOCK;
        }
        if (Clock.Type.SSN_30_DAY_PSEUDO_SSN_VERIFICATION_CLOCK.getName().equals(type)) {
            return Clock.Type.SSN_30_DAY_PSEUDO_SSN_VERIFICATION_CLOCK;
        }                
        return null;
    }
    
    /**
     * @return Returns the commsLogService.
     */
    public CommsLogService getCommsLogService() {
        return commsLogService;
    }

    /**
     * @param commsLogService The commsLogService to set.
     */
    public void setCommsLogService(CommsLogService commsLogService) {
        this.commsLogService = commsLogService;
    }

    /**
     * @return Returns the personService.
     */
    public PersonService getPersonService() {
        return personService;
    }

    /**
     * @param personService The personService to set.
     */
    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
    
    
}
