package gov.va.med.esr.common.clock;




// Java classes

// Library classes

// Framework classes

// ESR classes
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.PurpleHeartService;

/**
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class PHClockProcess extends AbstractClockProcess {
    private PurpleHeartService purpleHeartService = null;
    private PersonService personService = null;    
    
    public PHClockProcess() {
        super();
    }

    protected void processClock(String personId, String clockType, String subject)
            throws Exception {
        Person person = this.getPersonService().getPerson(CommonEntityKeyFactory.createPersonIdEntityKey(personId));
        Clock.Type firedClockType = convertStrToClockType(clockType);
        // Tell service what clock fired
        this.getPurpleHeartService().updatePurpleHeart(person, firedClockType);
    }

    /**
     * @return Returns the personService.
     */
    public PersonService getPersonService() {
        return personService;
    }

    /**
     * @param personService The personService to set.
     */
    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    /**
     * @return Returns the purpleHeartService.
     */
    public PurpleHeartService getPurpleHeartService() {
        return purpleHeartService;
    }

    /**
     * @param purpleHeartService The purpleHeartService to set.
     */
    public void setPurpleHeartService(PurpleHeartService purpleHeartService) {
        this.purpleHeartService = purpleHeartService;
    }

    protected Clock.Type convertStrToClockType(String type) {
        // Convert all clock types here
        if (Clock.Type.PH_14_DAY_CLOCK.getName().equals(type)) {
            return Clock.Type.PH_14_DAY_CLOCK;
        }
        if (Clock.Type.PH_37_DAY_CLOCK.getName().equals(type)) {
            return Clock.Type.PH_37_DAY_CLOCK;
        }
        return null;
    }    
}
