package gov.va.med.esr.common.clock;

// Java classes

// Library classes
import org.apache.commons.lang.Validate;

import gov.va.med.fw.scheduling.AbstractScheduledProcess;
import gov.va.med.fw.scheduling.ScheduledProcessInvocationContext;


// ESR classes

public abstract class AbstractClockProcess extends AbstractScheduledProcess {
    private static final int VALID_MIN_SIZE = 2;
    
    public AbstractClockProcess() {
        super();
    }

    protected void executeProcess(ScheduledProcessInvocationContext context) throws Exception {
    	Object args = context.getInvocationArguments();
        if (args instanceof Object[]) {
            Object list[] = (Object[])args;
            boolean validSize = list.length >= VALID_MIN_SIZE;
            Validate.isTrue(validSize,"Parameters passed to clock process are invalid");            
            
            String personId =  (String)list[0];
            String clockType = (String)list[1];
            String subject = list.length > VALID_MIN_SIZE ? (String)list[2] : null;            
            
            Validate.notNull(personId, "The person id must not be null ");
            Validate.notNull(clockType, "The clock type must not be null ");
            // subject is not required
            
            if(logger.isInfoEnabled())
            	logger.info("Executing clock process"); // " for: " + clockType);
            
            processClock(personId, clockType, subject);            
        }
    }

    protected abstract void processClock(String personId, String clockType, String subject) throws Exception;
    
    protected abstract Clock.Type convertStrToClockType(String type); 
}
